/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.buildtools.gradle.internal;

import javax.inject.Inject;
import org.graalvm.buildtools.gradle.dsl.GraalVMExtension;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Named;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;

public class DefaultTestBinaryConfig
implements GraalVMExtension.TestBinaryConfig,
Named {
    private final String name;
    private TaskProvider<Test> testTask;
    private SourceSet sourceSet;

    @Inject
    public DefaultTestBinaryConfig(String name) {
        this.name = name;
    }

    @Override
    public void forTestTask(TaskProvider<Test> jvmTestTask) {
        this.testTask = jvmTestTask;
    }

    @Override
    public void usingSourceSet(SourceSet testSourceSet) {
        this.sourceSet = testSourceSet;
    }

    public String getName() {
        return this.name;
    }

    public TaskProvider<Test> getTestTask() {
        return this.testTask;
    }

    public SourceSet getSourceSet() {
        return this.sourceSet;
    }

    public DefaultTestBinaryConfig validate() {
        if (this.testTask == null) {
            throw new InvalidUserCodeException("On custom test binary '" + this.name + "', you must specify a JVM test task to mirror");
        }
        if (this.sourceSet == null) {
            throw new InvalidUserCodeException("On custom test binary '" + this.name + "', you must specify a test source set to use");
        }
        return this;
    }
}

