/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;
import javax.crypto.Cipher;
import org.flywaydb.FlywayExpiredLicenseKeyException;
import org.flywaydb.FlywayInvalidLicenseKeyException;
import org.flywaydb.FlywayMissingLicenseKeyException;
import org.flywaydb.FlywayRedgateLicenseKeyException;
import org.flywaydb.LicenseType;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayTrialExpiredException;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.StringUtils;

public class LicenseInfo {
    private static final Log LOG = LogFactory.getLog(LicenseInfo.class);
    private final LicenseType licenseType;
    private final String licensedTo;
    private final Date validUntil;
    private static final String DECRYPTION_KEY = "30820122300d06092a864886f70d01010105000382010f003082010a02820101009fbebb4eb38e68c758ff04f2ca68f6c37660eb5b821aabbfac7c221c54debec144edacc9f95005f8070f0ee20fc54c8e913ae859e2a96864ebe7d153a092e12379cfae26ba615f778db674452d0466c4259faadce1772b3e4b71f4a63c8c6856e093e9e279c9f0834b986606e223c691cfddba18e5cfc54d0f50f1c44eeafefaad2e805edd67946d69902a0fe1d119e7814a5add199ba95ffa9e2318240040219a96ba1f3a55a96359d2c590b3050f77f5b9950d04f3e77aa891578e0800fb16e4d122bcdd3f422cb846f982a5177b803d3fbfd45b4c61d6182ca429b85c77bed678fd345bcbae01c51aef2ecf0bd1c3f85aeebe60380933501cf0b98eca97670203010001";

    private LicenseInfo(LicenseType licenseType, Date validUntil, String licensedTo) {
        this.licenseType = licenseType;
        this.validUntil = validUntil;
        this.licensedTo = licensedTo;
    }

    public static LicenseInfo create(String licenseKey) {
        LicenseInfo.validateLicenseKey(licenseKey);
        byte[] decrypted = LicenseInfo.rsaDecrypt(LicenseInfo.fromHex(licenseKey.substring(4)), LicenseInfo.rsaPublicKey(LicenseInfo.fromHex(DECRYPTION_KEY)));
        int year = 2000 + decrypted[1];
        byte month = decrypted[2];
        byte day = decrypted[3];
        LicenseType licenseType = LicenseType.fromCode(decrypted[0]);
        Date validUntil = DateUtils.toDate((int)year, (int)month, (int)day);
        String licensedTo = new String(Arrays.copyOfRange(decrypted, 4, decrypted.length), StandardCharsets.UTF_8);
        LicenseInfo licenseInfo = new LicenseInfo(licenseType, validUntil, licensedTo);
        if (licenseInfo.getValidUntil().before(new Date())) {
            if (licenseType == LicenseType.TRIAL) {
                throw new FlywayTrialExpiredException(licenseType.getEdition());
            }
            throw new FlywayExpiredLicenseKeyException(licenseType.getEdition());
        }
        VersionPrinter.EDITION = licenseType.getEdition();
        return licenseInfo;
    }

    public void print() {
        LOG.info("Licensed to " + this.getLicensedTo() + " until " + DateUtils.toDateString((Date)this.getValidUntil()));
        if (Edition.PRO.equals((Object)this.licenseType.getEdition())) {
            LOG.info("Your Flyway license is upgraded to Flyway Teams.");
        }
        if (this.licenseType == LicenseType.TRIAL) {
            LOG.warn("You are using a limited Flyway trial license, valid until " + this.getValidUntil() + ".  In " + this.getRemainingDaysString() + " you must either upgrade to a full " + VersionPrinter.EDITION + " license or downgrade to " + Edition.COMMUNITY + ".");
        }
        LOG.info("");
    }

    private static void validateLicenseKey(String licenseKey) {
        if (!StringUtils.hasLength((String)licenseKey)) {
            throw new FlywayMissingLicenseKeyException();
        }
        if (licenseKey.matches("[0-9]{3}-[0-9]{3}-[0-9]{6}-[A-Z0-9]{4}")) {
            throw new FlywayRedgateLicenseKeyException();
        }
        if (!licenseKey.matches("FL01[A-F0-9]{512}")) {
            throw new FlywayInvalidLicenseKeyException();
        }
    }

    public long getRemainingDays() {
        return ChronoUnit.DAYS.between(new Date().toInstant(), this.validUntil.toInstant());
    }

    public String getRemainingDaysString() {
        long daysRemaining = this.getRemainingDays();
        return daysRemaining + (daysRemaining == 1L ? " day" : " days");
    }

    private static PublicKey rsaPublicKey(byte[] publicKey) {
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        }
        catch (GeneralSecurityException e) {
            throw new FlywayException("Unable to load the license decryption key", (Throwable)e);
        }
    }

    private static byte[] rsaDecrypt(byte[] encrypted, Key key) {
        try {
            Cipher rsa = Cipher.getInstance("RSA/ECB/Pkcs1Padding");
            rsa.init(2, key);
            return rsa.doFinal(encrypted);
        }
        catch (GeneralSecurityException e) {
            throw new FlywayInvalidLicenseKeyException("Unable to decrypt license", e);
        }
    }

    public static byte[] fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return binary;
    }

    public LicenseType getLicenseType() {
        return this.licenseType;
    }

    public String getLicensedTo() {
        return this.licensedTo;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }
}

