/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.teams.db2zos;

import java.sql.Connection;
import java.sql.SQLException;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSDatabase;
import org.flywaydb.core.internal.database.teams.db2zos.DB2zOSSchema;

public class DB2zOSConnection
extends org.flywaydb.core.internal.database.base.Connection<DB2zOSDatabase> {
    private final String tablespace;

    DB2zOSConnection(Configuration configuration, DB2zOSDatabase database, Connection connection) {
        super(database, connection);
        this.tablespace = configuration.getTablespace();
    }

    @Override
    protected String getCurrentSchemaNameOrSearchPath() throws SQLException {
        return this.jdbcTemplate.queryForString("select current_schema from sysibm.sysdummy1", new String[0]);
    }

    @Override
    public void doChangeCurrentSchemaOrSearchPathTo(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + ((DB2zOSDatabase)this.database).quote(schema), new Object[0]);
    }

    @Override
    public Schema getSchema(String name) {
        return new DB2zOSSchema(this.jdbcTemplate, (DB2zOSDatabase)this.database, name, this.tablespace);
    }
}

