/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.resource.Resource;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusAtParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusDefineParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusExecuteParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusLoginStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusPlaceholderProvider;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusPlaceholderReplacingReader;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusPromptParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusRemarkParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusSetParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusShowParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusSpoolParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusUndefineParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusUnsupportedParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusWheneverSqlerrorParsedSqlStatement;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParserContext;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.parser.PeekingReader;
import org.flywaydb.core.internal.parser.PositionTracker;
import org.flywaydb.core.internal.parser.Recorder;
import org.flywaydb.core.internal.parser.StatementType;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;
import org.flywaydb.core.internal.sqlscript.Delimiter;
import org.flywaydb.core.internal.sqlscript.ParsedSqlStatement;
import org.flywaydb.core.internal.sqlscript.SqlScriptMetadata;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.StringUtils;

public class OracleParser
extends Parser {
    private static final Delimiter PLSQL_DELIMITER = new Delimiter("/", true, null);
    private static final Delimiter SQLPLUS_DELIMITER = new Delimiter("\n", false, "-");
    private static final String ACCESSIBLE_BY_REGEX = "ACCESSIBLE\\sBY\\s\\(?((FUNCTION|PROCEDURE|PACKAGE|TRIGGER|TYPE)\\s[^\\s]*\\s?+)*\\)?";
    private static final Pattern PLSQL_TYPE_BODY_REGEX = Pattern.compile("^CREATE(\\sOR\\sREPLACE)?(\\s(NON)?EDITIONABLE)?\\sTYPE\\sBODY\\s([^\\s]*\\s)?(IS|AS)");
    private static final Pattern PLSQL_PACKAGE_BODY_REGEX = Pattern.compile("^CREATE(\\s*OR\\s*REPLACE)?(\\s*(NON)?EDITIONABLE)?\\s*PACKAGE\\s*BODY\\s*([^\\s]*\\s)?(IS|AS)");
    private static final StatementType PLSQL_PACKAGE_BODY_STATEMENT = new StatementType();
    private static final Pattern PLSQL_PACKAGE_DEFINITION_REGEX = Pattern.compile("^CREATE(\\s*OR\\s*REPLACE)?(\\s*(NON)?EDITIONABLE)?\\s*PACKAGE\\s([^\\s*]*\\s*)?(AUTHID\\s*[^\\s*]*\\s*|ACCESSIBLE\\sBY\\s\\(?((FUNCTION|PROCEDURE|PACKAGE|TRIGGER|TYPE)\\s[^\\s]*\\s?+)*\\)?)*(IS|AS)");
    private static final Pattern PLSQL_VIEW_REGEX = Pattern.compile("^CREATE(\\sOR\\sREPLACE)?(\\s(NON)?EDITIONABLE)?\\sVIEW\\s([^\\s]*\\s)?AS\\sWITH\\s(PROCEDURE|FUNCTION)");
    private static final StatementType PLSQL_VIEW_STATEMENT = new StatementType();
    private static final Pattern PLSQL_REGEX = Pattern.compile("^CREATE(\\sOR\\sREPLACE)?(\\s(NON)?EDITIONABLE)?\\s(FUNCTION(\\s\\S*)|PROCEDURE|TYPE|TRIGGER)");
    private static final Pattern DECLARE_BEGIN_REGEX = Pattern.compile("^DECLARE|BEGIN|WITH");
    private static final StatementType PLSQL_STATEMENT = new StatementType();
    private static final Pattern JAVA_REGEX = Pattern.compile("^CREATE(\\sOR\\sREPLACE)?(\\sAND\\s(RESOLVE|COMPILE))?(\\sNOFORCE)?\\sJAVA\\s(SOURCE|RESOURCE|CLASS)");
    private static final StatementType PLSQL_JAVA_STATEMENT = new StatementType();
    private static final Pattern PLSQL_PACKAGE_BODY_WRAPPED_REGEX = Pattern.compile("^CREATE(\\sOR\\sREPLACE)?(\\s(NON)?EDITIONABLE)?\\sPACKAGE\\sBODY(\\s\\S*)?\\sWRAPPED(\\s\\S*)*");
    private static final Pattern PLSQL_PACKAGE_DEFINITION_WRAPPED_REGEX = Pattern.compile("^CREATE(\\sOR\\sREPLACE)?(\\s(NON)?EDITIONABLE)?\\sPACKAGE(\\s\\S*)?\\sWRAPPED(\\s\\S*)*");
    private static final Pattern PLSQL_WRAPPED_REGEX = Pattern.compile("^CREATE(\\sOR\\sREPLACE)?(\\s(NON)?EDITIONABLE)?\\s(FUNCTION|PROCEDURE|TYPE)(\\s\\S*)?\\sWRAPPED(\\s\\S*)*");
    private static final StatementType PLSQL_WRAPPED_STATEMENT = new StatementType();
    private int initialWrappedBlockDepth = -1;
    private static final String UNSUPPORTED_SQLPLUS_COMMANDS = "ACC(EPT)?|A(PPEND)?|ARCHIVE|ATTR(IBUTE)?|BRE(AK)?|BTI(TLE)?|C(HANGE)?|CL(EAR)?|COL(UMN)?|COMP(UTE)?|CONN(ECT)?|COPY|DEL|DESC(RIBE)?|DISC(ONNECT)?|ED(IT)?|EXIT|GET|HELP|HIST(ORY)?|HO(ST)?|I(NPUT)?|L(IST)?|PASSW(ORD)?|PAU(SE)?|PRINT|PURGE|QUIT|RECOVER|REPF(OOTER)?|REPH(EADER)?|R(UN)?|SAV(E)?|SHUTDOWN|STARTUP|STORE|TIMI(NG)?|TTI(TLE)?|VAR(IABLE)?|WHENEVER OSERROR|XQUERY";
    private static final Pattern UNSUPPORTED_SQLPLUS_COMMANDS_REGEX = OracleParser.toRegex("ACC(EPT)?|A(PPEND)?|ARCHIVE|ATTR(IBUTE)?|BRE(AK)?|BTI(TLE)?|C(HANGE)?|CL(EAR)?|COL(UMN)?|COMP(UTE)?|CONN(ECT)?|COPY|DEL|DESC(RIBE)?|DISC(ONNECT)?|ED(IT)?|EXIT|GET|HELP|HIST(ORY)?|HO(ST)?|I(NPUT)?|L(IST)?|PASSW(ORD)?|PAU(SE)?|PRINT|PURGE|QUIT|RECOVER|REPF(OOTER)?|REPH(EADER)?|R(UN)?|SAV(E)?|SHUTDOWN|STARTUP|STORE|TIMI(NG)?|TTI(TLE)?|VAR(IABLE)?|WHENEVER OSERROR|XQUERY");
    private static final SQLPlusStatementType UNSUPPORTED_SQLPLUS_STATEMENT = new SQLPlusStatementType();
    private static final String AT_COMMANDS = "@";
    private static final Pattern AT_REGEX = OracleParser.toRegex("@");
    private static final SQLPlusStatementType AT_STATEMENT = new SQLPlusStatementType();
    private static final String DEFINE_COMMANDS = "DEF(INE)?";
    private static final Pattern DEFINE_REGEX = OracleParser.toRegex("DEF(INE)?");
    private static final SQLPlusStatementType DEFINE_STATEMENT = new SQLPlusStatementType();
    private static final String EXECUTE_COMMANDS = "EXEC(UTE)?";
    private static final Pattern EXECUTE_REGEX = OracleParser.toRegex("EXEC(UTE)?");
    private static final SQLPlusStatementType EXECUTE_STATEMENT = new SQLPlusStatementType();
    private static final String PROMPT_COMMANDS = "PRO(MPT)?";
    private static final Pattern PROMPT_REGEX = OracleParser.toRegex("PRO(MPT)?");
    private static final SQLPlusStatementType PROMPT_STATEMENT = new SQLPlusStatementType();
    private static final String REMARK_COMMANDS = "REM(ARK)?";
    private static final Pattern REMARK_REGEX = OracleParser.toRegex("REM(ARK)?");
    private static final SQLPlusStatementType REMARK_STATEMENT = new SQLPlusStatementType();
    private static final String SET_COMMANDS = "SET";
    private static final Pattern SET_REGEX = OracleParser.toRegex("SET");
    private static final SQLPlusStatementType SET_STATEMENT = new SQLPlusStatementType();
    private static final String SHOW_COMMANDS = "SHO(W)?";
    private static final Pattern SHOW_REGEX = OracleParser.toRegex("SHO(W)?");
    private static final SQLPlusStatementType SHOW_STATEMENT = new SQLPlusStatementType();
    private static final String SPOOL_COMMANDS = "SPO(OL)?";
    private static final Pattern SPOOL_REGEX = OracleParser.toRegex("SPO(OL)?");
    public static final SQLPlusSpoolStatementType SPOOL_STATEMENT = new SQLPlusSpoolStatementType();
    private static final String START_COMMANDS = "STA(RT)?";
    private static final Pattern START_REGEX = OracleParser.toRegex("STA(RT)?");
    private static final String UNDEFINE_COMMANDS = "UNDEF(INE)?";
    private static final Pattern UNDEFINE_REGEX = OracleParser.toRegex("UNDEF(INE)?");
    private static final SQLPlusStatementType UNDEFINE_STATEMENT = new SQLPlusStatementType();
    private static final String WHENEVER_SQLERROR_COMMANDS = "WHENEVER SQLERROR";
    private static final Pattern WHENEVER_SQLERROR_REGEX = OracleParser.toRegex("WHENEVER SQLERROR");
    private static final SQLPlusStatementType WHENEVER_SQLERROR_STATEMENT = new SQLPlusStatementType();
    private final boolean oracleSqlplus;
    private final boolean oracleSqlplusWarn;
    private final SQLPlusPlaceholderProvider sqlPlusPlaceholderProvider;
    private final ResourceProvider resourceProvider;
    private static final List<String> CONTROL_FLOW_KEYWORDS = Arrays.asList("IF", "LOOP", "CASE");
    boolean hasReturnedGlobalLoginStatement = false;
    boolean hasReturnedLocalLoginStatement = false;

    private static Pattern toRegex(String ... commands) {
        return Pattern.compile(OracleParser.toRegexPattern(commands));
    }

    private static String toRegexPattern(String ... commands) {
        return "^(" + StringUtils.arrayToDelimitedString("|", commands) + ")";
    }

    public OracleParser(Configuration configuration, boolean oracleSqlplus, boolean oracleSqlplusWarn, SQLPlusPlaceholderProvider sqlPlusPlaceholderProvider, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        super(configuration, parsingContext, 3);
        this.oracleSqlplus = oracleSqlplus;
        this.oracleSqlplusWarn = oracleSqlplusWarn;
        this.sqlPlusPlaceholderProvider = sqlPlusPlaceholderProvider;
        this.resourceProvider = resourceProvider;
    }

    @Override
    protected Reader replacePlaceholders(Reader r, SqlScriptMetadata metadata) {
        r = super.replacePlaceholders(r, metadata);
        if (this.oracleSqlplus) {
            return new SQLPlusPlaceholderReplacingReader(this.sqlPlusPlaceholderProvider, r);
        }
        return r;
    }

    @Override
    protected boolean supportsPeekingMultipleLines() {
        return false;
    }

    public SQLPlusPlaceholderProvider getSqlPlusPlaceholderProvider() {
        return this.sqlPlusPlaceholderProvider;
    }

    @Override
    protected ParsedSqlStatement createStatement(PeekingReader reader, Recorder recorder, int statementPos, int statementLine, int statementCol, int nonCommentPartPos, int nonCommentPartLine, int nonCommentPartCol, StatementType statementType, boolean canExecuteInTransaction, Delimiter delimiter, String sql, List<Token> tokens, boolean batchable) throws IOException {
        if (this.oracleSqlplus) {
            if (AT_STATEMENT == statementType) {
                return new SQLPlusAtParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql, this.sqlPlusPlaceholderProvider, this, this.resourceProvider);
            }
            if (DEFINE_STATEMENT == statementType) {
                return new SQLPlusDefineParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql, tokens, this.sqlPlusPlaceholderProvider);
            }
            if (EXECUTE_STATEMENT == statementType) {
                return new SQLPlusExecuteParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql);
            }
            if (PROMPT_STATEMENT == statementType) {
                return new SQLPlusPromptParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql, tokens);
            }
            if (REMARK_STATEMENT == statementType) {
                return new SQLPlusRemarkParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql);
            }
            if (SET_STATEMENT == statementType) {
                return new SQLPlusSetParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql, tokens, this.sqlPlusPlaceholderProvider);
            }
            if (SHOW_STATEMENT == statementType) {
                return new SQLPlusShowParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql, this.sqlPlusPlaceholderProvider);
            }
            if (SPOOL_STATEMENT == statementType) {
                return new SQLPlusSpoolParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql, tokens);
            }
            if (UNDEFINE_STATEMENT == statementType) {
                return new SQLPlusUndefineParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql, tokens, this.sqlPlusPlaceholderProvider);
            }
            if (WHENEVER_SQLERROR_STATEMENT == statementType) {
                return new SQLPlusWheneverSqlerrorParsedSqlStatement(nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, sql, tokens);
            }
            if (UNSUPPORTED_SQLPLUS_STATEMENT == statementType) {
                return new SQLPlusUnsupportedParsedSqlStatement(statementPos, statementLine, statementCol, sql, this.oracleSqlplusWarn);
            }
        }
        if (PLSQL_VIEW_STATEMENT == statementType && (sql = sql.trim()).endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1);
        }
        return super.createStatement(reader, recorder, statementPos, statementLine, statementCol, nonCommentPartPos, nonCommentPartLine, nonCommentPartCol, statementType, canExecuteInTransaction, delimiter, sql, tokens, batchable);
    }

    @Override
    protected StatementType detectStatementType(String simplifiedStatement, ParserContext context, PeekingReader reader) {
        if (PLSQL_PACKAGE_BODY_WRAPPED_REGEX.matcher(simplifiedStatement).matches() || PLSQL_PACKAGE_DEFINITION_WRAPPED_REGEX.matcher(simplifiedStatement).matches() || PLSQL_WRAPPED_REGEX.matcher(simplifiedStatement).matches()) {
            if (this.initialWrappedBlockDepth == -1) {
                this.initialWrappedBlockDepth = context.getBlockDepth();
            }
            return PLSQL_WRAPPED_STATEMENT;
        }
        if (PLSQL_PACKAGE_BODY_REGEX.matcher(simplifiedStatement).matches()) {
            return PLSQL_PACKAGE_BODY_STATEMENT;
        }
        if (PLSQL_REGEX.matcher(simplifiedStatement).matches() || PLSQL_PACKAGE_DEFINITION_REGEX.matcher(simplifiedStatement).matches() || DECLARE_BEGIN_REGEX.matcher(simplifiedStatement).matches()) {
            try {
                String wrappedKeyword = " WRAPPED";
                if (!reader.peek(wrappedKeyword.length()).equalsIgnoreCase(wrappedKeyword)) {
                    return PLSQL_STATEMENT;
                }
            }
            catch (IOException e) {
                return PLSQL_STATEMENT;
            }
        }
        if (JAVA_REGEX.matcher(simplifiedStatement).matches()) {
            return PLSQL_JAVA_STATEMENT;
        }
        if (PLSQL_VIEW_REGEX.matcher(simplifiedStatement).matches()) {
            return PLSQL_VIEW_STATEMENT;
        }
        if (this.oracleSqlplus) {
            if (AT_REGEX.matcher(simplifiedStatement).matches() || START_REGEX.matcher(simplifiedStatement).matches()) {
                return AT_STATEMENT;
            }
            if (DEFINE_REGEX.matcher(simplifiedStatement).matches()) {
                return DEFINE_STATEMENT;
            }
            if (EXECUTE_REGEX.matcher(simplifiedStatement).matches()) {
                return EXECUTE_STATEMENT;
            }
            if (PROMPT_REGEX.matcher(simplifiedStatement).matches()) {
                return PROMPT_STATEMENT;
            }
            if (REMARK_REGEX.matcher(simplifiedStatement).matches()) {
                return REMARK_STATEMENT;
            }
            if (SET_REGEX.matcher(simplifiedStatement).matches()) {
                return SET_STATEMENT;
            }
            if (SHOW_REGEX.matcher(simplifiedStatement).matches()) {
                return SHOW_STATEMENT;
            }
            if (SPOOL_REGEX.matcher(simplifiedStatement).matches()) {
                return SPOOL_STATEMENT;
            }
            if (UNDEFINE_REGEX.matcher(simplifiedStatement).matches()) {
                return UNDEFINE_STATEMENT;
            }
            if (WHENEVER_SQLERROR_REGEX.matcher(simplifiedStatement).matches()) {
                return WHENEVER_SQLERROR_STATEMENT;
            }
            if (UNSUPPORTED_SQLPLUS_COMMANDS_REGEX.matcher(simplifiedStatement).matches()) {
                return UNSUPPORTED_SQLPLUS_STATEMENT;
            }
        }
        return super.detectStatementType(simplifiedStatement, context, reader);
    }

    @Override
    protected boolean shouldDiscard(Token token, boolean nonCommentPartSeen) {
        return "/".equals(token.getText()) && !nonCommentPartSeen || super.shouldDiscard(token, nonCommentPartSeen);
    }

    @Override
    protected void adjustDelimiter(ParserContext context, StatementType statementType) {
        if (statementType == PLSQL_STATEMENT || statementType == PLSQL_VIEW_STATEMENT || statementType == PLSQL_JAVA_STATEMENT || statementType == PLSQL_PACKAGE_BODY_STATEMENT) {
            context.setDelimiter(PLSQL_DELIMITER);
        } else if (statementType instanceof SQLPlusStatementType) {
            context.setDelimiter(SQLPLUS_DELIMITER);
        } else {
            context.setDelimiter(Delimiter.SEMICOLON);
        }
    }

    @Override
    public boolean supportsReferencedSqlScripts() {
        return this.oracleSqlplus;
    }

    @Override
    protected boolean isKeyword(String text) {
        return "SQL.SQLCODE".equalsIgnoreCase(text) || super.isKeyword(text);
    }

    @Override
    protected boolean shouldAdjustBlockDepth(ParserContext context, List<Token> tokens, Token token) {
        TokenType tokenType = token.getType();
        if (context.getStatementType() == PLSQL_PACKAGE_BODY_STATEMENT && (TokenType.EOF == tokenType || TokenType.DELIMITER == tokenType)) {
            return true;
        }
        if (context.getStatementType() == PLSQL_WRAPPED_STATEMENT && (TokenType.EOF == tokenType || TokenType.DELIMITER == tokenType)) {
            return true;
        }
        if (token.getType() == TokenType.SYMBOL && context.getStatementType() == PLSQL_JAVA_STATEMENT) {
            return true;
        }
        if (context.getStatementType() == REMARK_STATEMENT || context.getStatementType() == PROMPT_STATEMENT) {
            return false;
        }
        return super.shouldAdjustBlockDepth(context, tokens, token);
    }

    @Override
    protected void adjustBlockDepth(ParserContext context, List<Token> tokens, Token keyword, PeekingReader reader) {
        TokenType tokenType = keyword.getType();
        String keywordText = keyword.getText();
        int parensDepth = keyword.getParensDepth();
        if (OracleParser.lastTokenIs(tokens, parensDepth, "GOTO")) {
            return;
        }
        if (context.getStatementType() == PLSQL_WRAPPED_STATEMENT) {
            if (context.getBlockDepth() == this.initialWrappedBlockDepth) {
                context.increaseBlockDepth("WRAPPED");
            }
            if (TokenType.EOF == tokenType && context.getBlockDepth() > 0) {
                context.decreaseBlockDepth();
            }
            return;
        }
        if (context.getBlockDepth() > this.initialWrappedBlockDepth && context.getBlockInitiator().equals("WRAPPED")) {
            this.initialWrappedBlockDepth = -1;
            context.decreaseBlockDepth();
        }
        if (context.getStatementType() == PLSQL_JAVA_STATEMENT) {
            if ("{".equals(keywordText)) {
                context.increaseBlockDepth("PLSQL_JAVA_STATEMENT");
            } else if ("}".equals(keywordText)) {
                context.decreaseBlockDepth();
            }
            return;
        }
        if ("BEGIN".equals(keywordText) || CONTROL_FLOW_KEYWORDS.contains(keywordText) && !this.precedingEndAttachesToThisKeyword(tokens, parensDepth, context, keyword) || "TRIGGER".equals(keywordText) && OracleParser.lastTokenIs(tokens, parensDepth, "COMPOUND") || context.getBlockDepth() == 0 && (this.doTokensMatchPattern(tokens, keyword, PLSQL_PACKAGE_BODY_REGEX) || this.doTokensMatchPattern(tokens, keyword, PLSQL_PACKAGE_DEFINITION_REGEX) || this.doTokensMatchPattern(tokens, keyword, PLSQL_TYPE_BODY_REGEX))) {
            context.increaseBlockDepth(keywordText);
        } else if ("END".equals(keywordText)) {
            context.decreaseBlockDepth();
        }
        if (context.getStatementType() == PLSQL_PACKAGE_BODY_STATEMENT && (TokenType.EOF == tokenType || TokenType.DELIMITER == tokenType) && context.getBlockDepth() == 1) {
            context.decreaseBlockDepth();
        }
    }

    private boolean precedingEndAttachesToThisKeyword(List<Token> tokens, int parensDepth, ParserContext context, Token keyword) {
        return OracleParser.lastTokenIs(tokens, parensDepth, "END") && OracleParser.lastTokenIsOnLine(tokens, parensDepth, keyword.getLine()) && keyword.getText().equals(context.getLastClosedBlockInitiator());
    }

    @Override
    protected boolean doTokensMatchPattern(List<Token> previousTokens, Token current, Pattern regex) {
        if (regex == PLSQL_PACKAGE_DEFINITION_REGEX && previousTokens.stream().anyMatch(t -> t.getType() == TokenType.KEYWORD && t.getText().equalsIgnoreCase("ACCESSIBLE"))) {
            ArrayList<String> tokenStrings = new ArrayList<String>();
            tokenStrings.add(current.getText());
            for (int i = previousTokens.size() - 1; i >= 0; --i) {
                Token prevToken = previousTokens.get(i);
                if (prevToken.getType() != TokenType.KEYWORD) continue;
                tokenStrings.add(prevToken.getText());
            }
            StringBuilder builder = new StringBuilder();
            for (int i = tokenStrings.size() - 1; i >= 0; --i) {
                builder.append((String)tokenStrings.get(i));
                if (i == 0) continue;
                builder.append(" ");
            }
            return regex.matcher(builder.toString()).matches() || super.doTokensMatchPattern(previousTokens, current, regex);
        }
        return super.doTokensMatchPattern(previousTokens, current, regex);
    }

    @Override
    protected boolean isDelimiter(String peek, ParserContext context, int col, int colIgnoringWhitespace) {
        Delimiter delimiter = context.getDelimiter();
        if (peek.startsWith(delimiter.getEscape() + delimiter.getDelimiter())) {
            return true;
        }
        if (delimiter.shouldBeAloneOnLine()) {
            return colIgnoringWhitespace == 1 && peek.trim().equals(delimiter.getDelimiter());
        }
        if (colIgnoringWhitespace == 1 && "/".equals(peek.trim())) {
            return true;
        }
        return super.isDelimiter(peek, context, col, colIgnoringWhitespace);
    }

    @Override
    protected Token handleDelimiter(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        String escape = context.getDelimiter().getEscape();
        if (escape != null && reader.peek(escape)) {
            reader.swallow(escape.length() + context.getDelimiter().getDelimiter().length());
            return null;
        }
        return super.handleDelimiter(reader, context, pos, line, col);
    }

    @Override
    protected boolean isAlternativeStringLiteral(String peek) {
        if (peek.length() < 3) {
            return false;
        }
        char firstChar = peek.charAt(0);
        return (firstChar == 'q' || firstChar == 'Q') && peek.charAt(1) == '\'';
    }

    @Override
    protected Token handleAlternativeStringLiteral(PeekingReader reader, ParserContext context, int pos, int line, int col) throws IOException {
        reader.swallow(2);
        String closeQuote = this.computeAlternativeCloseQuote((char)reader.read());
        reader.swallowUntilExcluding(closeQuote);
        reader.swallow(closeQuote.length());
        return new Token(TokenType.STRING, pos, line, col, null, null, context.getParensDepth());
    }

    private String computeAlternativeCloseQuote(char specialChar) {
        switch (specialChar) {
            case '!': {
                return "!'";
            }
            case '[': {
                return "]'";
            }
            case '(': {
                return ")'";
            }
            case '{': {
                return "}'";
            }
            case '<': {
                return ">'";
            }
        }
        return specialChar + "'";
    }

    @Override
    protected SqlStatement getNextStatement(Resource resource, PeekingReader reader, Recorder recorder, PositionTracker tracker, ParserContext context) {
        if (this.oracleSqlplus) {
            SQLPlusLoginStatement statement;
            if (!this.hasReturnedGlobalLoginStatement) {
                this.hasReturnedGlobalLoginStatement = true;
                statement = new SQLPlusLoginStatement(this, this.resourceProvider, true);
                if (statement.getReferencedSqlScript() != null) {
                    return statement;
                }
            }
            if (!this.hasReturnedLocalLoginStatement) {
                this.hasReturnedLocalLoginStatement = true;
                statement = new SQLPlusLoginStatement(this, this.resourceProvider, false);
                if (statement.getReferencedSqlScript() != null) {
                    return statement;
                }
            }
        }
        return super.getNextStatement(resource, reader, recorder, tracker, context);
    }

    private static class SQLPlusSpoolStatementType
    extends SQLPlusStatementType {
        private SQLPlusSpoolStatementType() {
        }

        @Override
        public boolean treatAsIfLetter(char c) {
            return c == '/' || c == '\\' || c == ':';
        }
    }

    static class SQLPlusStatementType
    extends StatementType {
        SQLPlusStatementType() {
        }
    }
}

