/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.testing;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.Database;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.InstanceId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.testing.EmulatorSpannerHelper;
import com.google.spanner.admin.database.v1.CreateDatabaseMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteSpannerHelper {
    private static final Logger logger = Logger.getLogger(RemoteSpannerHelper.class.getName());
    private final SpannerOptions options;
    private final Spanner client;
    private final InstanceId instanceId;
    private static int dbSeq;
    private static int dbPrefix;
    private static final AtomicInteger backupSeq;
    private static int backupPrefix;
    private final List<Database> dbs = new ArrayList<Database>();

    protected RemoteSpannerHelper(SpannerOptions options, InstanceId instanceId, Spanner client) {
        this.options = options;
        this.instanceId = instanceId;
        this.client = client;
    }

    public SpannerOptions getOptions() {
        return this.options;
    }

    @Deprecated
    public boolean isEmulator() {
        return EmulatorSpannerHelper.isUsingEmulator();
    }

    public Spanner getClient() {
        return this.client;
    }

    public DatabaseClient getDatabaseClient(Database db) {
        return this.getClient().getDatabaseClient(db.getId());
    }

    public BatchClient getBatchClient(Database db) {
        return this.getClient().getBatchClient(db.getId());
    }

    public InstanceId getInstanceId() {
        return this.instanceId;
    }

    public Database createTestDatabase(String ... statements) throws SpannerException {
        return this.createTestDatabase(Arrays.asList(statements));
    }

    public String getUniqueDatabaseId() {
        return String.format("testdb_%d_%04d", dbPrefix, dbSeq++);
    }

    public String getUniqueBackupId() {
        return String.format("testbck_%06d_%04d", backupPrefix, backupSeq.incrementAndGet());
    }

    public Database createTestDatabase(Iterable<String> statements) throws SpannerException {
        String dbId = this.getUniqueDatabaseId();
        try {
            OperationFuture<Database, CreateDatabaseMetadata> op = this.client.getDatabaseAdminClient().createDatabase(this.instanceId.getInstance(), dbId, statements);
            Database db = (Database)op.get();
            logger.log(Level.FINE, "Created test database {0}", db.getId());
            this.dbs.add(db);
            return db;
        }
        catch (Exception e) {
            throw SpannerExceptionFactory.newSpannerException(e);
        }
    }

    public void cleanUp() {
        int numDropped = 0;
        for (Database db : this.dbs) {
            try {
                logger.log(Level.FINE, "Dropping test database {0}", db.getId());
                db.drop();
                ++numDropped;
            }
            catch (SpannerException e) {
                logger.log(Level.SEVERE, "Failed to drop test database " + db.getId(), (Throwable)((Object)e));
            }
        }
        logger.log(Level.INFO, "Dropped {0} test database(s)", numDropped);
    }

    public static RemoteSpannerHelper create(InstanceId instanceId) {
        SpannerOptions options = ((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(instanceId.getProject())).setAutoThrottleAdministrativeRequests().setTrackTransactionStarter().build();
        Spanner client = (Spanner)options.getService();
        return new RemoteSpannerHelper(options, instanceId, client);
    }

    public static RemoteSpannerHelper create(SpannerOptions options, InstanceId instanceId) {
        Spanner client = (Spanner)options.getService();
        return new RemoteSpannerHelper(options, instanceId, client);
    }

    static {
        dbPrefix = new Random().nextInt(Integer.MAX_VALUE);
        backupSeq = new AtomicInteger();
        backupPrefix = new Random().nextInt(Integer.MAX_VALUE);
    }
}

