/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.util.Objects;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.gds.ng.WireCrypt;

public abstract class AbstractAttachProperties<T extends IAttachProperties>
implements IAttachProperties<T> {
    private String serverName = "localhost";
    private int portNumber = 3050;
    private String user;
    private String password;
    private String roleName;
    private String charSet;
    private String encoding;
    private int socketBufferSize = -1;
    private int soTimeout = -1;
    private int connectTimeout = -1;
    private WireCrypt wireCrypt = WireCrypt.DEFAULT;
    private String dbCryptConfig;

    protected AbstractAttachProperties(IAttachProperties src) {
        if (src != null) {
            this.serverName = src.getServerName();
            this.portNumber = src.getPortNumber();
            this.user = src.getUser();
            this.password = src.getPassword();
            this.roleName = src.getRoleName();
            this.charSet = src.getCharSet();
            this.encoding = src.getEncoding();
            this.socketBufferSize = src.getSocketBufferSize();
            this.soTimeout = src.getSoTimeout();
            this.connectTimeout = src.getConnectTimeout();
            this.wireCrypt = src.getWireCrypt();
            this.dbCryptConfig = src.getDbCryptConfig();
        }
    }

    protected AbstractAttachProperties() {
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    @Override
    public void setServerName(String serverName) {
        this.serverName = serverName;
        this.dirtied();
    }

    @Override
    public int getPortNumber() {
        return this.portNumber;
    }

    @Override
    public void setPortNumber(int portNumber) {
        this.portNumber = portNumber;
        this.dirtied();
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public void setUser(String user) {
        this.user = user;
        this.dirtied();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
        this.dirtied();
    }

    @Override
    public String getRoleName() {
        return this.roleName;
    }

    @Override
    public void setRoleName(String roleName) {
        this.roleName = roleName;
        this.dirtied();
    }

    @Override
    public String getCharSet() {
        return this.charSet;
    }

    @Override
    public void setCharSet(String charSet) {
        this.charSet = charSet;
        this.dirtied();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
        this.dirtied();
    }

    @Override
    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    @Override
    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
        this.dirtied();
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
        this.dirtied();
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        this.dirtied();
    }

    @Override
    public WireCrypt getWireCrypt() {
        return this.wireCrypt;
    }

    @Override
    public void setWireCrypt(WireCrypt wireCrypt) {
        this.wireCrypt = Objects.requireNonNull(wireCrypt, "wireCrypt");
        this.dirtied();
    }

    @Override
    public String getDbCryptConfig() {
        return this.dbCryptConfig;
    }

    @Override
    public void setDbCryptConfig(String dbCryptConfig) {
        this.dbCryptConfig = dbCryptConfig;
        this.dirtied();
    }

    protected abstract void dirtied();
}

