/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.spring.configurator;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.zip.ZipInputStream;
import org.flowable.common.engine.impl.lock.LockManager;
import org.flowable.common.spring.CommonAutoDeploymentProperties;
import org.flowable.common.spring.CommonAutoDeploymentStrategy;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.repository.DeploymentBuilder;
import org.springframework.core.io.Resource;

public abstract class AbstractProcessAutoDeploymentStrategy
extends CommonAutoDeploymentStrategy<ProcessEngine> {
    public AbstractProcessAutoDeploymentStrategy() {
    }

    public AbstractProcessAutoDeploymentStrategy(CommonAutoDeploymentProperties deploymentProperties) {
        super(deploymentProperties);
    }

    protected LockManager getLockManager(ProcessEngine engine, String deploymentNameHint) {
        return engine.getManagementService().getLockManager(this.determineLockName(deploymentNameHint));
    }

    protected void addResource(Resource resource, DeploymentBuilder deploymentBuilder) {
        String resourceName = this.determineResourceName(resource);
        this.addResource(resource, resourceName, deploymentBuilder);
    }

    protected void addResource(Resource resource, String resourceName, DeploymentBuilder deploymentBuilder) {
        block14: {
            try (InputStream inputStream = resource.getInputStream();){
                if (resourceName.endsWith(".bar") || resourceName.endsWith(".zip") || resourceName.endsWith(".jar")) {
                    try (ZipInputStream zipStream = new ZipInputStream(inputStream);){
                        deploymentBuilder.addZipInputStream(zipStream);
                        break block14;
                    }
                }
                deploymentBuilder.addInputStream(resourceName, inputStream);
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read resource " + resource, ex);
            }
        }
    }
}

