/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.scripting;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.scripting.DefaultScriptTrace;
import org.flowable.common.engine.impl.scripting.FlowableScriptEvaluationException;
import org.flowable.common.engine.impl.scripting.ScriptBindingsFactory;
import org.flowable.common.engine.impl.scripting.ScriptEngineRequest;
import org.flowable.common.engine.impl.scripting.ScriptEvaluation;
import org.flowable.common.engine.impl.scripting.ScriptEvaluationImpl;
import org.flowable.common.engine.impl.scripting.ScriptTrace;
import org.flowable.common.engine.impl.scripting.ScriptTraceEnhancer;
import org.flowable.common.engine.impl.scripting.ScriptTraceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingEngines {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptingEngines.class);
    public static final String DEFAULT_SCRIPTING_LANGUAGE = "juel";
    public static final String GROOVY_SCRIPTING_LANGUAGE = "groovy";
    private final ScriptEngineManager scriptEngineManager;
    protected ScriptBindingsFactory scriptBindingsFactory;
    protected boolean cacheScriptingEngines = true;
    protected Map<String, ScriptEngine> cachedEngines;
    protected ScriptTraceEnhancer defaultTraceEnhancer;
    protected ScriptTraceListener scriptErrorListener = null;
    protected ScriptTraceListener scriptSuccessListener = null;

    public ScriptingEngines(ScriptBindingsFactory scriptBindingsFactory) {
        this(new ScriptEngineManager());
        this.scriptBindingsFactory = scriptBindingsFactory;
    }

    public ScriptingEngines(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
        this.cachedEngines = new HashMap<String, ScriptEngine>();
    }

    public ScriptEvaluation evaluate(ScriptEngineRequest request) {
        Bindings bindings = this.createBindings(request);
        Object result = this.evaluate(request, bindings);
        return new ScriptEvaluationImpl(bindings, result);
    }

    protected Object evaluate(ScriptEngineRequest request, Bindings bindings) {
        ScriptEngine scriptEngine = this.getEngineByName(request.getLanguage());
        return this.evaluate(scriptEngine, request, bindings);
    }

    protected Object evaluate(ScriptEngine scriptEngine, ScriptEngineRequest request, Bindings bindings) {
        long startNanos = System.nanoTime();
        try {
            Object scriptResult = scriptEngine.eval(request.getScript(), bindings);
            if (this.scriptSuccessListener != null) {
                DefaultScriptTrace scriptTrace = DefaultScriptTrace.successTrace(Duration.ofNanos(System.nanoTime() - startNanos), request);
                this.enhanceScriptTrace(request, scriptTrace);
                this.notifyScriptTraceListener(this.scriptSuccessListener, scriptTrace);
            }
            return scriptResult;
        }
        catch (ScriptException e) {
            Throwable rootCause;
            DefaultScriptTrace scriptTrace = DefaultScriptTrace.errorTrace(Duration.ofNanos(System.nanoTime() - startNanos), request, e);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Caught exception evaluating script. {}{}{}", new Object[]{request.getLanguage(), System.lineSeparator(), request.getScript()});
            }
            this.enhanceScriptTrace(request, scriptTrace);
            if (this.scriptErrorListener != null) {
                this.notifyScriptTraceListener(this.scriptErrorListener, scriptTrace);
            }
            if ((rootCause = ExceptionUtils.getRootCause((Throwable)e)) instanceof FlowableException) {
                throw (FlowableException)rootCause;
            }
            throw new FlowableScriptEvaluationException(scriptTrace, e);
        }
    }

    protected void notifyScriptTraceListener(ScriptTraceListener listener, ScriptTrace scriptTrace) {
        try {
            listener.onScriptTrace(scriptTrace);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while executing scriptTraceListener: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected void enhanceScriptTrace(ScriptEngineRequest request, DefaultScriptTrace scriptTrace) {
        if (this.defaultTraceEnhancer != null) {
            this.defaultTraceEnhancer.enhanceScriptTrace(scriptTrace);
        }
        if (request.getTraceEnhancer() != null) {
            request.getTraceEnhancer().enhanceScriptTrace(scriptTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ScriptEngine getEngineByName(String language) {
        ScriptEngine scriptEngine = null;
        if (this.cacheScriptingEngines) {
            scriptEngine = this.cachedEngines.get(language);
            if (scriptEngine == null) {
                ScriptEngineManager scriptEngineManager = this.scriptEngineManager;
                synchronized (scriptEngineManager) {
                    scriptEngine = this.cachedEngines.get(language);
                    if (scriptEngine != null) {
                        return scriptEngine;
                    }
                    scriptEngine = this.scriptEngineManager.getEngineByName(language);
                    if (scriptEngine != null) {
                        Object threadingParameter;
                        if (GROOVY_SCRIPTING_LANGUAGE.equals(language)) {
                            try {
                                scriptEngine.getContext().setAttribute("#jsr223.groovy.engine.keep.globals", "weak", 100);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((threadingParameter = scriptEngine.getFactory().getParameter("THREADING")) != null) {
                            this.cachedEngines.put(language, scriptEngine);
                        }
                    }
                }
            }
        } else {
            scriptEngine = this.scriptEngineManager.getEngineByName(language);
        }
        if (scriptEngine == null) {
            throw new FlowableException("Can't find scripting engine for '" + language + "'");
        }
        return scriptEngine;
    }

    protected Bindings createBindings(ScriptEngineRequest request) {
        return this.scriptBindingsFactory.createBindings(request);
    }

    public ScriptBindingsFactory getScriptBindingsFactory() {
        return this.scriptBindingsFactory;
    }

    public void setScriptBindingsFactory(ScriptBindingsFactory scriptBindingsFactory) {
        this.scriptBindingsFactory = scriptBindingsFactory;
    }

    public void setScriptEngineFactories(List<ScriptEngineFactory> scriptEngineFactories) {
        if (scriptEngineFactories != null) {
            for (ScriptEngineFactory scriptEngineFactory : scriptEngineFactories) {
                this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
            }
        }
    }

    public ScriptingEngines addScriptEngineFactory(ScriptEngineFactory scriptEngineFactory) {
        this.scriptEngineManager.registerEngineName(scriptEngineFactory.getEngineName(), scriptEngineFactory);
        return this;
    }

    public void setCacheScriptingEngines(boolean cacheScriptingEngines) {
        this.cacheScriptingEngines = cacheScriptingEngines;
    }

    public boolean isCacheScriptingEngines() {
        return this.cacheScriptingEngines;
    }

    public ScriptTraceEnhancer getDefaultTraceEnhancer() {
        return this.defaultTraceEnhancer;
    }

    public void setDefaultTraceEnhancer(ScriptTraceEnhancer defaultTraceEnhancer) {
        this.defaultTraceEnhancer = defaultTraceEnhancer;
    }

    public ScriptTraceListener getScriptErrorListener() {
        return this.scriptErrorListener;
    }

    public void setScriptErrorListener(ScriptTraceListener scriptErrorListener) {
        this.scriptErrorListener = scriptErrorListener;
    }

    public ScriptTraceListener getScriptSuccessListener() {
        return this.scriptSuccessListener;
    }

    public void setScriptSuccessListener(ScriptTraceListener scriptSuccessListener) {
        this.scriptSuccessListener = scriptSuccessListener;
    }

    public ScriptEngineManager getScriptEngineManager() {
        return this.scriptEngineManager;
    }
}

