/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.image.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.flowable.dmn.image.exception.FlowableImageException;
import org.flowable.dmn.image.util.ReflectUtil;
import org.flowable.dmn.model.GraphicInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecisionRequirementsDiagramCanvas {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultDecisionRequirementsDiagramCanvas.class);
    protected static final int ARROW_WIDTH = 5;
    protected static final int MARKER_WIDTH = 12;
    protected static final int FONT_SIZE = 11;
    protected static final int FONT_SPACING = 2;
    protected static final int TEXT_PADDING = 3;
    protected static final Color TASK_BOX_COLOR = new Color(249, 249, 249);
    protected static final Color CONNECTION_COLOR = new Color(88, 88, 88);
    protected static final Color HIGHLIGHT_COLOR = Color.RED;
    protected static final Color LABEL_COLOR = new Color(112, 146, 190);
    protected static final Color TASK_BORDER_COLOR = new Color(187, 187, 187);
    protected static Font LABEL_FONT;
    protected static Font ANNOTATION_FONT;
    protected static final Stroke THICK_TASK_BORDER_STROKE;
    protected static final int ICON_PADDING = 5;
    protected static BufferedImage DECISION_IMAGE;
    protected int canvasWidth = -1;
    protected int canvasHeight = -1;
    protected int minX = -1;
    protected int minY = -1;
    protected BufferedImage decisionRequirementsDiagram;
    protected Graphics2D g;
    protected FontMetrics fontMetrics;
    protected boolean closed;
    protected ClassLoader customClassLoader;
    protected String activityFontName = "Arial";
    protected String labelFontName = "Arial";
    protected String annotationFontName = "Arial";

    public DefaultDecisionRequirementsDiagramCanvas(int width, int height, int minX, int minY, String imageType, String activityFontName, String labelFontName, String annotationFontName, ClassLoader customClassLoader) {
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.minX = minX;
        this.minY = minY;
        if (activityFontName != null) {
            this.activityFontName = activityFontName;
        }
        if (labelFontName != null) {
            this.labelFontName = labelFontName;
        }
        if (annotationFontName != null) {
            this.annotationFontName = annotationFontName;
        }
        this.customClassLoader = customClassLoader;
        this.initialize(imageType);
    }

    public DefaultDecisionRequirementsDiagramCanvas(int width, int height, int minX, int minY, String imageType) {
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.minX = minX;
        this.minY = minY;
        this.initialize(imageType);
    }

    public void initialize(String imageType) {
        this.decisionRequirementsDiagram = "png".equalsIgnoreCase(imageType) ? new BufferedImage(this.canvasWidth, this.canvasHeight, 2) : new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        this.g = this.decisionRequirementsDiagram.createGraphics();
        if (!"png".equalsIgnoreCase(imageType)) {
            this.g.setBackground(new Color(255, 255, 255, 0));
            this.g.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
        }
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setPaint(Color.black);
        Font font = new Font(this.activityFontName, 1, 11);
        this.g.setFont(font);
        this.fontMetrics = this.g.getFontMetrics();
        LABEL_FONT = new Font(this.labelFontName, 2, 10);
        ANNOTATION_FONT = new Font(this.annotationFontName, 0, 11);
        try {
            DECISION_IMAGE = ImageIO.read(ReflectUtil.getResource("org/flowable/icons/decision.png", this.customClassLoader));
        }
        catch (IOException e) {
            LOGGER.warn("Could not load image for decision requirements diagram creation: {}", (Object)e.getMessage());
        }
    }

    public InputStream generateImage(String imageType) {
        ByteArrayInputStream byteArrayInputStream;
        if (this.closed) {
            throw new FlowableImageException("CaseDiagramGenerator already closed");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)this.decisionRequirementsDiagram, imageType, out);
            byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new FlowableImageException("Error while generating case image", e);
            }
        }
        out.close();
        return byteArrayInputStream;
    }

    public BufferedImage generateBufferedImage(String imageType) {
        if (this.closed) {
            throw new FlowableImageException("DecisionRequirementsDiagramGenerator already closed");
        }
        this.minX = this.minX <= 5 ? 5 : this.minX;
        this.minY = this.minY <= 5 ? 5 : this.minY;
        BufferedImage imageToSerialize = this.decisionRequirementsDiagram;
        imageToSerialize = this.decisionRequirementsDiagram.getSubimage(this.minX - 5, this.minY - 5, this.canvasWidth - this.minX + 5, this.canvasHeight - this.minY + 5);
        return imageToSerialize;
    }

    public void close() {
        this.g.dispose();
        this.closed = true;
    }

    public void drawInformationRequirement(int[] xPoints, int[] yPoints, double scaleFactor) {
        this.drawConnection(xPoints, yPoints, "informationRequirement", scaleFactor);
    }

    public void drawConnection(int[] xPoints, int[] yPoints, String connectionType, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(CONNECTION_COLOR);
        for (int i = 1; i < xPoints.length; ++i) {
            int sourceX = xPoints[i - 1];
            int sourceY = yPoints[i - 1];
            int targetX = xPoints[i];
            int targetY = yPoints[i];
            Line2D.Double line = new Line2D.Double(sourceX, sourceY, targetX, targetY);
            this.g.draw(line);
        }
        Line2D.Double line = new Line2D.Double(xPoints[xPoints.length - 2], yPoints[xPoints.length - 2], xPoints[xPoints.length - 1], yPoints[xPoints.length - 1]);
        this.drawArrowHead(line, scaleFactor);
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    public void drawArrowHead(Line2D.Double line, double scaleFactor) {
        int doubleArrowWidth = (int)(10.0 / scaleFactor);
        if (doubleArrowWidth == 0) {
            doubleArrowWidth = 2;
        }
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, 0);
        int arrowHeadPoint = (int)(-5.0 / scaleFactor);
        if (arrowHeadPoint == 0) {
            arrowHeadPoint = -1;
        }
        arrowHead.addPoint(arrowHeadPoint, -doubleArrowWidth);
        arrowHeadPoint = (int)(5.0 / scaleFactor);
        if (arrowHeadPoint == 0) {
            arrowHeadPoint = 1;
        }
        arrowHead.addPoint(arrowHeadPoint, -doubleArrowWidth);
        AffineTransform transformation = new AffineTransform();
        transformation.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        transformation.translate(line.x2, line.y2);
        transformation.rotate(angle - 1.5707963267948966);
        AffineTransform originalTransformation = this.g.getTransform();
        this.g.setTransform(transformation);
        this.g.fill(arrowHead);
        this.g.setTransform(originalTransformation);
    }

    public void drawDecision(BufferedImage icon, String name, GraphicInfo graphicInfo, double scaleFactor) {
        this.drawDecision(name, graphicInfo, scaleFactor);
        this.g.drawImage(icon, (int)(graphicInfo.getX() + 5.0 / scaleFactor), (int)(graphicInfo.getY() + 5.0 / scaleFactor), (int)((double)icon.getWidth() / scaleFactor), (int)((double)icon.getHeight() / scaleFactor), null);
    }

    public void drawDecision(String name, GraphicInfo graphicInfo, double scaleFactor) {
        this.drawDecision(name, graphicInfo, false, scaleFactor);
    }

    public void drawDecisionService(String name, GraphicInfo graphicInfo, List<GraphicInfo> dividerGraphicInfos, double scaleFactor) {
        int x = (int)graphicInfo.getX();
        int y = (int)graphicInfo.getY();
        int width = (int)graphicInfo.getWidth();
        int height = (int)graphicInfo.getHeight();
        this.g.drawRoundRect(x, y, width, height, 48, 48);
        int dividerLeftX = (int)dividerGraphicInfos.get(0).getX();
        int dividerLeftY = (int)dividerGraphicInfos.get(0).getY();
        int dividerRightX = (int)dividerGraphicInfos.get(1).getX();
        int dividerRightY = (int)dividerGraphicInfos.get(1).getY();
        this.g.drawLine(dividerLeftX, dividerLeftY, dividerRightX, dividerRightY);
        if (scaleFactor == 1.0 && name != null && name.length() > 0) {
            int availableTextSpace = width - 48;
            String truncated = this.fitTextToWidth(name, availableTextSpace);
            int realWidth = this.fontMetrics.stringWidth(truncated);
            this.g.drawString(truncated, x + 24 + (availableTextSpace - realWidth) / 2, 6 + y + this.fontMetrics.getHeight());
        }
    }

    protected void drawDecision(String name, GraphicInfo graphicInfo, boolean thickBorder, double scaleFactor) {
        Paint originalPaint = this.g.getPaint();
        int x = (int)graphicInfo.getX();
        int y = (int)graphicInfo.getY();
        int width = (int)graphicInfo.getWidth();
        int height = (int)graphicInfo.getHeight();
        this.g.setPaint(TASK_BOX_COLOR);
        int arcR = 6;
        if (thickBorder) {
            arcR = 3;
        }
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, arcR, arcR);
        this.g.fill(rect);
        this.g.setPaint(TASK_BORDER_COLOR);
        if (thickBorder) {
            Stroke originalStroke = this.g.getStroke();
            this.g.setStroke(THICK_TASK_BORDER_STROKE);
            this.g.draw(rect);
            this.g.setStroke(originalStroke);
        } else {
            this.g.draw(rect);
        }
        this.g.setPaint(originalPaint);
        if (scaleFactor == 1.0 && name != null && name.length() > 0) {
            int boxWidth = width - 6;
            int boxHeight = height - 16 - 5 - 5 - 12 - 2 - 2;
            int boxX = x + width / 2 - boxWidth / 2;
            int boxY = y + height / 2 - boxHeight / 2 + 5 + 5 - 2 - 2;
            this.drawMultilineCentredText(name, boxX, boxY, boxWidth, boxHeight);
        }
    }

    protected void drawMultilineCentredText(String text, int x, int y, int boxWidth, int boxHeight) {
        this.drawMultilineText(text, x, y, boxWidth, boxHeight, true);
    }

    protected void drawMultilineAnnotationText(String text, int x, int y, int boxWidth, int boxHeight) {
        this.drawMultilineText(text, x, y, boxWidth, boxHeight, false);
    }

    protected void drawMultilineText(String text, int x, int y, int boxWidth, int boxHeight, boolean centered) {
        int currentHeight;
        int height;
        AttributedString attributedString = new AttributedString(text);
        attributedString.addAttribute(TextAttribute.FONT, this.g.getFont());
        attributedString.addAttribute(TextAttribute.FOREGROUND, Color.black);
        AttributedCharacterIterator characterIterator = attributedString.getIterator();
        ArrayList<TextLayout> layouts = new ArrayList<TextLayout>();
        String lastLine = null;
        LineBreakMeasurer measurer = new LineBreakMeasurer(characterIterator, this.g.getFontRenderContext());
        TextLayout layout = null;
        for (currentHeight = 0; measurer.getPosition() < characterIterator.getEndIndex() && currentHeight <= boxHeight; currentHeight += height) {
            int previousPosition = measurer.getPosition();
            layout = measurer.nextLayout(boxWidth);
            height = Float.valueOf(layout.getDescent() + layout.getAscent() + layout.getLeading()).intValue();
            if (currentHeight + height > boxHeight) {
                if (layouts.isEmpty()) break;
                layouts.remove(layouts.size() - 1);
                if (lastLine.length() >= 4) {
                    lastLine = lastLine.substring(0, lastLine.length() - 4) + "...";
                }
                layouts.add(new TextLayout(lastLine, this.g.getFont(), this.g.getFontRenderContext()));
                break;
            }
            layouts.add(layout);
            lastLine = text.substring(previousPosition, measurer.getPosition());
        }
        int currentY = y + (centered ? (boxHeight - currentHeight) / 2 : 0);
        int currentX = 0;
        for (TextLayout textLayout : layouts) {
            currentY = (int)((float)currentY + textLayout.getAscent());
            currentX = x + (centered ? (boxWidth - Double.valueOf(textLayout.getBounds().getWidth()).intValue()) / 2 : 0);
            textLayout.draw(this.g, currentX, currentY);
            currentY = (int)((float)currentY + (textLayout.getDescent() + textLayout.getLeading()));
        }
    }

    protected String fitTextToWidth(String original, int width) {
        String text = original;
        int maxWidth = width - 10;
        while (this.fontMetrics.stringWidth(text + "...") > maxWidth && text.length() > 0) {
            text = text.substring(0, text.length() - 1);
        }
        if (!text.equals(original)) {
            text = text + "...";
        }
        return text;
    }

    public void drawHighLight(int x, int y, int width, int height) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(HIGHLIGHT_COLOR);
        this.g.setStroke(THICK_TASK_BORDER_STROKE);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
        this.g.draw(rect);
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    public List<GraphicInfo> connectionPerfectionizer(SHAPE_TYPE sourceShapeType, SHAPE_TYPE targetShapeType, GraphicInfo sourceGraphicInfo, GraphicInfo targetGraphicInfo, List<GraphicInfo> graphicInfoList) {
        Shape shapeFirst = DefaultDecisionRequirementsDiagramCanvas.createShape(sourceShapeType, sourceGraphicInfo);
        Shape shapeLast = DefaultDecisionRequirementsDiagramCanvas.createShape(targetShapeType, targetGraphicInfo);
        if (graphicInfoList != null && graphicInfoList.size() > 0) {
            Line2D.Double lineLast;
            Line2D.Double lineFirst;
            GraphicInfo graphicInfoFirst = graphicInfoList.get(0);
            GraphicInfo graphicInfoLast = graphicInfoList.get(graphicInfoList.size() - 1);
            if (shapeFirst != null) {
                graphicInfoFirst.setX(shapeFirst.getBounds2D().getCenterX());
                graphicInfoFirst.setY(shapeFirst.getBounds2D().getCenterY());
            }
            if (shapeLast != null) {
                graphicInfoLast.setX(shapeLast.getBounds2D().getCenterX());
                graphicInfoLast.setY(shapeLast.getBounds2D().getCenterY());
            }
            Point p = null;
            if (shapeFirst != null && (p = DefaultDecisionRequirementsDiagramCanvas.getIntersection(shapeFirst, lineFirst = new Line2D.Double(graphicInfoFirst.getX(), graphicInfoFirst.getY(), graphicInfoList.get(1).getX(), graphicInfoList.get(1).getY()))) != null) {
                graphicInfoFirst.setX(p.getX());
                graphicInfoFirst.setY(p.getY());
            }
            if (shapeLast != null && (p = DefaultDecisionRequirementsDiagramCanvas.getIntersection(shapeLast, lineLast = new Line2D.Double(graphicInfoLast.getX(), graphicInfoLast.getY(), graphicInfoList.get(graphicInfoList.size() - 2).getX(), graphicInfoList.get(graphicInfoList.size() - 2).getY()))) != null) {
                graphicInfoLast.setX(p.getX());
                graphicInfoLast.setY(p.getY());
            }
        }
        return graphicInfoList;
    }

    private static Shape createShape(SHAPE_TYPE shapeType, GraphicInfo graphicInfo) {
        if (SHAPE_TYPE.Rectangle == shapeType) {
            return new Rectangle2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight());
        }
        if (SHAPE_TYPE.Rhombus == shapeType) {
            Path2D.Double rhombus = new Path2D.Double();
            rhombus.moveTo(graphicInfo.getX(), graphicInfo.getY() + graphicInfo.getHeight() / 2.0);
            rhombus.lineTo(graphicInfo.getX() + graphicInfo.getWidth() / 2.0, graphicInfo.getY() + graphicInfo.getHeight());
            rhombus.lineTo(graphicInfo.getX() + graphicInfo.getWidth(), graphicInfo.getY() + graphicInfo.getHeight() / 2.0);
            rhombus.lineTo(graphicInfo.getX() + graphicInfo.getWidth() / 2.0, graphicInfo.getY());
            rhombus.lineTo(graphicInfo.getX(), graphicInfo.getY() + graphicInfo.getHeight() / 2.0);
            rhombus.closePath();
            return rhombus;
        }
        if (SHAPE_TYPE.Ellipse == shapeType) {
            return new Ellipse2D.Double(graphicInfo.getX(), graphicInfo.getY(), graphicInfo.getWidth(), graphicInfo.getHeight());
        }
        return null;
    }

    private static Point getIntersection(Shape shape, Line2D.Double line) {
        if (shape instanceof Ellipse2D) {
            return DefaultDecisionRequirementsDiagramCanvas.getEllipseIntersection(shape, line);
        }
        if (shape instanceof Rectangle2D || shape instanceof Path2D) {
            return DefaultDecisionRequirementsDiagramCanvas.getShapeIntersection(shape, line);
        }
        return null;
    }

    private static Point getEllipseIntersection(Shape shape, Line2D.Double line) {
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        double x = shape.getBounds2D().getWidth() / 2.0 * Math.cos(angle) + shape.getBounds2D().getCenterX();
        double y = shape.getBounds2D().getHeight() / 2.0 * Math.sin(angle) + shape.getBounds2D().getCenterY();
        Point p = new Point();
        p.setLocation(x, y);
        return p;
    }

    private static Point getShapeIntersection(Shape shape, Line2D.Double line) {
        PathIterator it = shape.getPathIterator(null);
        double[] coords = new double[6];
        double[] pos = new double[2];
        Line2D.Double l = new Line2D.Double();
        while (!it.isDone()) {
            int type = it.currentSegment(coords);
            switch (type) {
                case 0: {
                    pos[0] = coords[0];
                    pos[1] = coords[1];
                    break;
                }
                case 1: {
                    l = new Line2D.Double(pos[0], pos[1], coords[0], coords[1]);
                    if (line.intersectsLine(l)) {
                        return DefaultDecisionRequirementsDiagramCanvas.getLinesIntersection(line, l);
                    }
                    pos[0] = coords[0];
                    pos[1] = coords[1];
                    break;
                }
                case 4: {
                    break;
                }
            }
            it.next();
        }
        return null;
    }

    private static Point getLinesIntersection(Line2D a, Line2D b) {
        double d = (a.getX1() - a.getX2()) * (b.getY2() - b.getY1()) - (a.getY1() - a.getY2()) * (b.getX2() - b.getX1());
        double da = (a.getX1() - b.getX1()) * (b.getY2() - b.getY1()) - (a.getY1() - b.getY1()) * (b.getX2() - b.getX1());
        double ta = da / d;
        Point p = new Point();
        p.setLocation(a.getX1() + ta * (a.getX2() - a.getX1()), a.getY1() + ta * (a.getY2() - a.getY1()));
        return p;
    }

    static {
        THICK_TASK_BORDER_STROKE = new BasicStroke(3.0f);
    }

    public static enum SHAPE_TYPE {
        Rectangle,
        Rhombus,
        Ellipse;

    }
}

