# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CollateralTreatment']


class CollateralTreatment(BaseDataClass):
  """
  Specifies the treatment terms for the eligible collateral criteria specified.
  """
  valuationTreatment: Optional[CollateralValuationTreatment] = Field(None, description="Specification of the valuation treatment for the specified collateral.")
  """
  Specification of the valuation treatment for the specified collateral.
  """
  concentrationLimit: List[ConcentrationLimit] = Field([], description="Specification of concentration limits applicable to the collateral criteria.")
  """
  Specification of concentration limits applicable to the collateral criteria.
  """
  isIncluded: bool = Field(..., description="A boolean attribute to specify whether collateral critieria are inclusion (True) or exclusion (False) criteria.")
  """
  A boolean attribute to specify whether collateral critieria are inclusion (True) or exclusion (False) criteria.
  """

from cdm.product.collateral.CollateralValuationTreatment import CollateralValuationTreatment
from cdm.product.collateral.ConcentrationLimit import ConcentrationLimit

CollateralTreatment.update_forward_refs()
