# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['CollateralInterestCalculationParameters']


class CollateralInterestCalculationParameters(BaseDataClass):
  """
  Represents parameters for calculating the amount the floating interest calculation, e.g.  for a single currency or defaults for all currencies.
  """
  fixedRate: Optional[Decimal] = Field(None, description="Specifies the applicable fixed rate if used.")
  """
  Specifies the applicable fixed rate  if used.
  """
  floatingRate: Optional[CollateralAgreementFloatingRate] = Field(None, description="Specifies the floating interest rate to be used.")
  """
  Specifies the floating interest rate to be used.
  """
  inBaseCurrency: bool = Field(..., description="If True, specifies that the interest transfers should be converted to base currency equivalent, or if False specifies that the transfer should be in the currency of the collateral.")
  """
  If True, specifies that the interest transfers should be converted to base currency equivalent, or if False specifies that the transfer should be in the currency of the collateral.
  """
  compoundingType: Optional[CompoundingTypeEnum] = Field(None, description="Specifies the type of compounding to be applied (None, Business, Calendar).")
  """
  Specifies the type of compounding to be applied (None, Business, Calendar).
  """
  compoundingBusinessCenter: List[BusinessCenterEnum] = Field([], description="Specifies the applicable business centers for compounding.")
  """
  Specifies the applicable business centers for compounding.
  """
  dayCountFraction: DayCountFractionEnum = Field(..., description="Specifies the day count fraction to use for that currency.")
  """
  Specifies the day count fraction to use for that currency.
  """
  rounding: Optional[Rounding] = Field(None, description="Specifies the rounding rules for settling in that currency.")
  """
  Specifies the rounding rules for settling in that currency.
  """
  roundingFrequency: Optional[RoundingFrequencyEnum] = Field(None, description="Specifies when/how often is rounding applied?")
  """
  Specifies when/how often is rounding applied?
  """
  withholdingTaxRate: Optional[Decimal] = Field(None, description="Specifies the withholding tax rate if a withholding tax is applicable.")
  """
  Specifies the withholding tax rate if a withholding tax is applicable.
  """
  
  @rosetta_condition
  def condition_0_InterestRate(self):
    return self.check_one_of_constraint('fixedRate', 'floatingRate', necessity=True)
  
  @rosetta_condition
  def condition_1_DCF(self):
    return (all_elements(_resolve_rosetta_attr(self, "dayCountFraction"), "=", _resolve_rosetta_attr(DayCountFractionEnum, "ACT_360")) or all_elements(_resolve_rosetta_attr(self, "dayCountFraction"), "=", _resolve_rosetta_attr(DayCountFractionEnum, "ACT_365_FIXED")))
  
  @rosetta_condition
  def condition_2_CompoundingBC1(self):
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "compoundingBusinessCenter")) is not None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(all_elements(_resolve_rosetta_attr(self, "compoundingType"), "=", _resolve_rosetta_attr(CompoundingTypeEnum, "BUSINESS")), _then_fn0, _else_fn0)
  
  @rosetta_condition
  def condition_3_CompoundingBC2(self):
    def _then_fn0():
      return ((_resolve_rosetta_attr(self, "compoundingBusinessCenter")) is None)
    
    def _else_fn0():
      return True
    
    return if_cond_fn(any_elements(_resolve_rosetta_attr(self, "compoundingType"), "<>", _resolve_rosetta_attr(CompoundingTypeEnum, "BUSINESS")), _then_fn0, _else_fn0)

from cdm.product.collateral.CollateralAgreementFloatingRate import CollateralAgreementFloatingRate
from cdm.base.datetime.CompoundingTypeEnum import CompoundingTypeEnum
from cdm.base.datetime.BusinessCenterEnum import BusinessCenterEnum
from cdm.base.datetime.daycount.DayCountFractionEnum import DayCountFractionEnum
from cdm.base.math.Rounding import Rounding
from cdm.base.datetime.RoundingFrequencyEnum import RoundingFrequencyEnum

CollateralInterestCalculationParameters.update_forward_refs()
