# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
from typing import List, Optional
from datetime import date
from datetime import time
from datetime import datetime
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import *

__all__ = ['AssetDeliveryProfile']


class AssetDeliveryProfile(BaseDataClass):
  """
  Defines the delivery profile of the asset, including the load type and the delivery intervals.
  """
  loadType: Optional[LoadTypeEnum] = Field(None, description="Identification of the delivery profile.")
  """
  Identification of the delivery profile.
  """
  block: List[AssetDeliveryProfileBlock] = Field([], description="Defines a delivery profile block, including start and end time, days of the week, duration, delivery capacity and price time interval quantity.")
  """
  Defines a delivery profile block, including start and end time, days of the week, duration, delivery capacity and price time interval quantity.
  """
  bankHolidaysTreatment: Optional[BankHolidayTreatmentEnum] = Field(None, description="Specifies whether the dates defined include holidays or not.")
  """
  Specifies whether the dates defined include holidays or not.
  """

from cdm.product.asset.LoadTypeEnum import LoadTypeEnum
from cdm.product.asset.AssetDeliveryProfileBlock import AssetDeliveryProfileBlock
from cdm.product.asset.BankHolidayTreatmentEnum import BankHolidayTreatmentEnum

AssetDeliveryProfile.update_forward_refs()
