/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.PerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PerformancePayoutQuantity")
@ImplementedBy(value=Default.class)
public interface PerformancePayoutQuantity
extends Validator<PerformancePayout> {
    public static final String NAME = "PerformancePayoutQuantity";
    public static final String DEFINITION = "priceQuantity exists";

    public ValidationResult<PerformancePayout> validate(RosettaPath var1, PerformancePayout var2);

    public static class NoOp
    implements PerformancePayoutQuantity {
        @Override
        public ValidationResult<PerformancePayout> validate(RosettaPath path, PerformancePayout performancePayout) {
            return ValidationResult.success((String)PerformancePayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutQuantity.DEFINITION);
        }
    }

    public static class Default
    implements PerformancePayoutQuantity {
        @Override
        public ValidationResult<PerformancePayout> validate(RosettaPath path, PerformancePayout performancePayout) {
            ComparisonResult result = this.executeDataRule(performancePayout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PerformancePayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutQuantity.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PerformancePayoutQuantity failed.";
            }
            return ValidationResult.failure((String)PerformancePayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PerformancePayout", (RosettaPath)path, (String)PerformancePayoutQuantity.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PerformancePayout performancePayout) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)performancePayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

