/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.ForwardPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="ForwardPayoutFxSettlement")
@ImplementedBy(value=Default.class)
public interface ForwardPayoutFxSettlement
extends Validator<ForwardPayout> {
    public static final String NAME = "ForwardPayoutFxSettlement";
    public static final String DEFINITION = "if underlier -> foreignExchange exists then settlementTerms -> physicalSettlementTerms is absent";

    public ValidationResult<ForwardPayout> validate(RosettaPath var1, ForwardPayout var2);

    public static class NoOp
    implements ForwardPayoutFxSettlement {
        @Override
        public ValidationResult<ForwardPayout> validate(RosettaPath path, ForwardPayout forwardPayout) {
            return ValidationResult.success((String)ForwardPayoutFxSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ForwardPayout", (RosettaPath)path, (String)ForwardPayoutFxSettlement.DEFINITION);
        }
    }

    public static class Default
    implements ForwardPayoutFxSettlement {
        @Override
        public ValidationResult<ForwardPayout> validate(RosettaPath path, ForwardPayout forwardPayout) {
            ComparisonResult result = this.executeDataRule(forwardPayout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ForwardPayoutFxSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ForwardPayout", (RosettaPath)path, (String)ForwardPayoutFxSettlement.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ForwardPayoutFxSettlement failed.";
            }
            return ValidationResult.failure((String)ForwardPayoutFxSettlement.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ForwardPayout", (RosettaPath)path, (String)ForwardPayoutFxSettlement.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(ForwardPayout forwardPayout) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)forwardPayout).map("getSettlementTerms", payoutBase -> payoutBase.getSettlementTerms()).map("getPhysicalSettlementTerms", settlementTerms -> settlementTerms.getPhysicalSettlementTerms()));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

