/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.AssetPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="AssetPayoutProductMustBeSecurity")
@ImplementedBy(value=Default.class)
public interface AssetPayoutProductMustBeSecurity
extends Validator<AssetPayout> {
    public static final String NAME = "AssetPayoutProductMustBeSecurity";
    public static final String DEFINITION = "securityInformation -> security exists";

    public ValidationResult<AssetPayout> validate(RosettaPath var1, AssetPayout var2);

    public static class NoOp
    implements AssetPayoutProductMustBeSecurity {
        @Override
        public ValidationResult<AssetPayout> validate(RosettaPath path, AssetPayout assetPayout) {
            return ValidationResult.success((String)AssetPayoutProductMustBeSecurity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutProductMustBeSecurity.DEFINITION);
        }
    }

    public static class Default
    implements AssetPayoutProductMustBeSecurity {
        @Override
        public ValidationResult<AssetPayout> validate(RosettaPath path, AssetPayout assetPayout) {
            ComparisonResult result = this.executeDataRule(assetPayout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)AssetPayoutProductMustBeSecurity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutProductMustBeSecurity.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition AssetPayoutProductMustBeSecurity failed.";
            }
            return ValidationResult.failure((String)AssetPayoutProductMustBeSecurity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AssetPayout", (RosettaPath)path, (String)AssetPayoutProductMustBeSecurity.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(AssetPayout assetPayout) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)assetPayout).map("getSecurityInformation", _assetPayout -> _assetPayout.getSecurityInformation()).map("getSecurity", product -> product.getSecurity()));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

