/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.asset.common.ProductBase;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.template.Product;
import cdm.product.template.meta.BasketMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Basket", builder=BasketBuilderImpl.class, version="5.0.0")
public interface Basket
extends ProductBase {
    public static final BasketMeta metaData = new BasketMeta();

    public List<? extends Product> getBasketConstituent();

    @Override
    public Basket build();

    @Override
    public BasketBuilder toBuilder();

    public static BasketBuilder builder() {
        return new BasketBuilderImpl();
    }

    default public RosettaMetaData<? extends Basket> metaData() {
        return metaData;
    }

    default public Class<? extends Basket> getType() {
        return Basket.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        ProductBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("basketConstituent"), processor, Product.class, this.getBasketConstituent(), new AttributeMeta[0]);
    }

    public static class BasketBuilderImpl
    extends ProductBase.ProductBaseBuilderImpl
    implements BasketBuilder {
        protected List<Product.ProductBuilder> basketConstituent = new ArrayList<Product.ProductBuilder>();

        @Override
        @RosettaAttribute(value="basketConstituent")
        public List<? extends Product.ProductBuilder> getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public Product.ProductBuilder getOrCreateBasketConstituent(int _index) {
            if (this.basketConstituent == null) {
                this.basketConstituent = new ArrayList<Product.ProductBuilder>();
            }
            return (Product.ProductBuilder)this.getIndex(this.basketConstituent, _index, () -> {
                Product.ProductBuilder newBasketConstituent = Product.builder();
                return newBasketConstituent;
            });
        }

        @Override
        public BasketBuilder addBasketConstituent(Product basketConstituent) {
            if (basketConstituent != null) {
                this.basketConstituent.add(basketConstituent.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituent(Product basketConstituent, int _idx) {
            this.getIndex(this.basketConstituent, _idx, () -> basketConstituent.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addBasketConstituent(List<? extends Product> basketConstituents) {
            if (basketConstituents != null) {
                for (Product product : basketConstituents) {
                    this.basketConstituent.add(product.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituent")
        public BasketBuilder setBasketConstituent(List<? extends Product> basketConstituents) {
            this.basketConstituent = basketConstituents == null ? new ArrayList<Product.ProductBuilder>() : (List)basketConstituents.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketBuilder addProductTaxonomy(ProductTaxonomy productTaxonomy) {
            if (productTaxonomy != null) {
                this.productTaxonomy.add(productTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addProductTaxonomy(ProductTaxonomy productTaxonomy, int _idx) {
            this.getIndex(this.productTaxonomy, _idx, () -> productTaxonomy.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            if (productTaxonomys != null) {
                for (ProductTaxonomy productTaxonomy : productTaxonomys) {
                    this.productTaxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="productTaxonomy")
        public BasketBuilder setProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            this.productTaxonomy = productTaxonomys == null ? new ArrayList() : (List)productTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier productIdentifier) {
            if (productIdentifier != null) {
                this.productIdentifier.add(productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier productIdentifier, int _idx) {
            this.getIndex(this.productIdentifier, _idx, () -> productIdentifier.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifierValue(ProductIdentifier productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifierValue(ProductIdentifier productIdentifier, int _idx) {
            this.getOrCreateProductIdentifier(_idx).setValue(productIdentifier.toBuilder());
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(referenceWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        public BasketBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public BasketBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public BasketBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        public Basket build() {
            return new BasketImpl(this);
        }

        @Override
        public BasketBuilder toBuilder() {
            return this;
        }

        @Override
        public BasketBuilder prune() {
            super.prune();
            this.basketConstituent = this.basketConstituent.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getBasketConstituent() != null && this.getBasketConstituent().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public BasketBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            BasketBuilder o = (BasketBuilder)other;
            merger.mergeRosetta(this.getBasketConstituent(), o.getBasketConstituent(), this::getOrCreateBasketConstituent);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Basket _that = (Basket)this.getType().cast(o);
            return ListEquals.listEquals(this.basketConstituent, _that.getBasketConstituent());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "BasketBuilder {basketConstituent=" + this.basketConstituent + '}' + " " + super.toString();
        }
    }

    public static class BasketImpl
    extends ProductBase.ProductBaseImpl
    implements Basket {
        private final List<? extends Product> basketConstituent;

        protected BasketImpl(BasketBuilder builder) {
            super(builder);
            this.basketConstituent = Optional.ofNullable(builder.getBasketConstituent()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="basketConstituent")
        public List<? extends Product> getBasketConstituent() {
            return this.basketConstituent;
        }

        @Override
        public Basket build() {
            return this;
        }

        @Override
        public BasketBuilder toBuilder() {
            BasketBuilder builder = Basket.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BasketBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBasketConstituent()).ifPresent(builder::setBasketConstituent);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Basket _that = (Basket)this.getType().cast(o);
            return ListEquals.listEquals(this.basketConstituent, _that.getBasketConstituent());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.basketConstituent != null ? this.basketConstituent.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Basket {basketConstituent=" + this.basketConstituent + '}' + " " + super.toString();
        }
    }

    public static interface BasketBuilder
    extends Basket,
    ProductBase.ProductBaseBuilder,
    RosettaModelObjectBuilder {
        public Product.ProductBuilder getOrCreateBasketConstituent(int var1);

        public List<? extends Product.ProductBuilder> getBasketConstituent();

        public BasketBuilder addBasketConstituent(Product var1);

        public BasketBuilder addBasketConstituent(Product var1, int var2);

        public BasketBuilder addBasketConstituent(List<? extends Product> var1);

        public BasketBuilder setBasketConstituent(List<? extends Product> var1);

        @Override
        public BasketBuilder addProductTaxonomy(ProductTaxonomy var1);

        @Override
        public BasketBuilder addProductTaxonomy(ProductTaxonomy var1, int var2);

        @Override
        public BasketBuilder addProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public BasketBuilder setProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public BasketBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1);

        @Override
        public BasketBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1, int var2);

        @Override
        public BasketBuilder addProductIdentifierValue(ProductIdentifier var1);

        @Override
        public BasketBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        @Override
        public BasketBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public BasketBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public BasketBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public BasketBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            ProductBase.ProductBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("basketConstituent"), processor, Product.ProductBuilder.class, this.getBasketConstituent(), new AttributeMeta[0]);
        }

        @Override
        public BasketBuilder prune();
    }
}

