/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.SettlementDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="SettlementDateBusinessDays")
@ImplementedBy(value=Default.class)
public interface SettlementDateBusinessDays
extends Validator<SettlementDate> {
    public static final String NAME = "SettlementDateBusinessDays";
    public static final String DEFINITION = "if cashSettlementBusinessDays exists then cashSettlementBusinessDays >= 0 else adjustableOrRelativeDate exists or valueDate exists or adjustableDates exists or businessDateRange exists";

    public ValidationResult<SettlementDate> validate(RosettaPath var1, SettlementDate var2);

    public static class NoOp
    implements SettlementDateBusinessDays {
        @Override
        public ValidationResult<SettlementDate> validate(RosettaPath path, SettlementDate settlementDate) {
            return ValidationResult.success((String)SettlementDateBusinessDays.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementDate", (RosettaPath)path, (String)SettlementDateBusinessDays.DEFINITION);
        }
    }

    public static class Default
    implements SettlementDateBusinessDays {
        @Override
        public ValidationResult<SettlementDate> validate(RosettaPath path, SettlementDate settlementDate) {
            ComparisonResult result = this.executeDataRule(settlementDate);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)SettlementDateBusinessDays.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementDate", (RosettaPath)path, (String)SettlementDateBusinessDays.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition SettlementDateBusinessDays failed.";
            }
            return ValidationResult.failure((String)SettlementDateBusinessDays.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"SettlementDate", (RosettaPath)path, (String)SettlementDateBusinessDays.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(SettlementDate settlementDate) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementDate).map("getCashSettlementBusinessDays", _settlementDate -> _settlementDate.getCashSettlementBusinessDays())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)settlementDate).map("getCashSettlementBusinessDays", _settlementDate -> _settlementDate.getCashSettlementBusinessDays()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementDate).map("getAdjustableOrRelativeDate", _settlementDate -> _settlementDate.getAdjustableOrRelativeDate())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementDate).map("getValueDate", _settlementDate -> _settlementDate.getValueDate()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementDate).map("getAdjustableDates", _settlementDate -> _settlementDate.getAdjustableDates()))).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)settlementDate).map("getBusinessDateRange", _settlementDate -> _settlementDate.getBusinessDateRange())));
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

