/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceQuantityObservableExists")
@ImplementedBy(value=Default.class)
public interface PriceQuantityObservableExists
extends Validator<PriceQuantity> {
    public static final String NAME = "PriceQuantityObservableExists";
    public static final String DEFINITION = "if price -> arithmeticOperator exists then observable exists";

    public ValidationResult<PriceQuantity> validate(RosettaPath var1, PriceQuantity var2);

    public static class NoOp
    implements PriceQuantityObservableExists {
        @Override
        public ValidationResult<PriceQuantity> validate(RosettaPath path, PriceQuantity priceQuantity) {
            return ValidationResult.success((String)PriceQuantityObservableExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityObservableExists.DEFINITION);
        }
    }

    public static class Default
    implements PriceQuantityObservableExists {
        @Override
        public ValidationResult<PriceQuantity> validate(RosettaPath path, PriceQuantity priceQuantity) {
            ComparisonResult result = this.executeDataRule(priceQuantity);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceQuantityObservableExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityObservableExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceQuantityObservableExists failed.";
            }
            return ValidationResult.failure((String)PriceQuantityObservableExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceQuantity", (RosettaPath)path, (String)PriceQuantityObservableExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceQuantity priceQuantity) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).mapC("getPrice", _priceQuantity -> _priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).map("getArithmeticOperator", priceSchedule -> priceSchedule.getArithmeticOperator())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)priceQuantity).map("getObservable", _priceQuantity -> _priceQuantity.getObservable()));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

