/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.base.datetime.PeriodRange;
import cdm.product.collateral.EligibilityQuery;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;

@ImplementedBy(value=CheckMaturityDefault.class)
public abstract class CheckMaturity
implements RosettaFunction {
    public Boolean evaluate(PeriodRange maturityRange, EligibilityQuery query) {
        Boolean isEqual = this.doEvaluate(maturityRange, query);
        return isEqual;
    }

    protected abstract Boolean doEvaluate(PeriodRange var1, EligibilityQuery var2);

    protected abstract Mapper<Boolean> upperBoundCheck(PeriodRange var1, EligibilityQuery var2);

    protected abstract Mapper<Boolean> lowerBoundCheck(PeriodRange var1, EligibilityQuery var2);

    public static class CheckMaturityDefault
    extends CheckMaturity {
        @Override
        protected Boolean doEvaluate(PeriodRange maturityRange, EligibilityQuery query) {
            Boolean isEqual = null;
            return this.assignOutput(isEqual, maturityRange, query);
        }

        protected Boolean assignOutput(Boolean isEqual, PeriodRange maturityRange, EligibilityQuery query) {
            isEqual = ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange)).or(ComparisonResult.of((Mapper)MapperS.of((Object)((Boolean)this.upperBoundCheck(maturityRange, query).get()))).and(ComparisonResult.of((Mapper)MapperS.of((Object)((Boolean)this.lowerBoundCheck(maturityRange, query).get()))))).get();
            return isEqual;
        }

        @Override
        protected Mapper<Boolean> upperBoundCheck(PeriodRange maturityRange, EligibilityQuery query) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getPeriod", periodBound -> periodBound.getPeriod())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)true);
                }
                if (ComparisonResult.of((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getInclusive", periodBound -> periodBound.getInclusive())).or(ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getInclusive", periodBound -> periodBound.getInclusive()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All);
                }
                return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)maturityRange).map("getUpperBound", periodRange -> periodRange.getUpperBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
            });
        }

        @Override
        protected Mapper<Boolean> lowerBoundCheck(PeriodRange maturityRange, EligibilityQuery query) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getPeriod", periodBound -> periodBound.getPeriod())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)true);
                }
                if (ComparisonResult.of((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getInclusive", periodBound -> periodBound.getInclusive())).or(ExpressionOperators.notExists((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getInclusive", periodBound -> periodBound.getInclusive()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.lessThanEquals((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All);
                }
                return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)maturityRange).map("getLowerBound", periodRange -> periodRange.getLowerBound()).map("getPeriod", periodBound -> periodBound.getPeriod()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()), (Mapper)MapperS.of((Object)query).map("getMaturity", eligibilityQuery -> eligibilityQuery.getMaturity()), (CardinalityOperator)CardinalityOperator.All).asMapper();
            });
        }
    }
}

