/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral.functions;

import cdm.base.datetime.PeriodRange;
import cdm.product.collateral.CheckEligibilityResult;
import cdm.product.collateral.EligibilityQuery;
import cdm.product.collateral.EligibleCollateralCriteria;
import cdm.product.collateral.EligibleCollateralSpecification;
import cdm.product.collateral.functions.CheckAgencyRating;
import cdm.product.collateral.functions.CheckAssetCountryOfOrigin;
import cdm.product.collateral.functions.CheckAssetType;
import cdm.product.collateral.functions.CheckDenominatedCurrency;
import cdm.product.collateral.functions.CheckIssuerName;
import cdm.product.collateral.functions.CheckIssuerType;
import cdm.product.collateral.functions.CheckMaturity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CheckEligibilityByDetailsDefault.class)
public abstract class CheckEligibilityByDetails
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CheckAgencyRating checkAgencyRating;
    @Inject
    protected CheckAssetCountryOfOrigin checkAssetCountryOfOrigin;
    @Inject
    protected CheckAssetType checkAssetType;
    @Inject
    protected CheckDenominatedCurrency checkDenominatedCurrency;
    @Inject
    protected CheckIssuerName checkIssuerName;
    @Inject
    protected CheckIssuerType checkIssuerType;
    @Inject
    protected CheckMaturity checkMaturity;

    public CheckEligibilityResult evaluate(EligibleCollateralSpecification specification, EligibilityQuery query) {
        CheckEligibilityResult eligibilityResult;
        CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResultBuilder = this.doEvaluate(specification, query);
        if (eligibilityResultBuilder == null) {
            eligibilityResult = null;
        } else {
            eligibilityResult = eligibilityResultBuilder.build();
            this.objectValidator.validate(CheckEligibilityResult.class, (RosettaModelObject)eligibilityResult);
        }
        return eligibilityResult;
    }

    protected abstract CheckEligibilityResult.CheckEligibilityResultBuilder doEvaluate(EligibleCollateralSpecification var1, EligibilityQuery var2);

    protected abstract Mapper<? extends EligibleCollateralCriteria> matchingEligibleCriteria(EligibleCollateralSpecification var1, EligibilityQuery var2);

    public static class CheckEligibilityByDetailsDefault
    extends CheckEligibilityByDetails {
        @Override
        protected CheckEligibilityResult.CheckEligibilityResultBuilder doEvaluate(EligibleCollateralSpecification specification, EligibilityQuery query) {
            CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResult = CheckEligibilityResult.builder();
            return this.assignOutput(eligibilityResult, specification, query);
        }

        protected CheckEligibilityResult.CheckEligibilityResultBuilder assignOutput(CheckEligibilityResult.CheckEligibilityResultBuilder eligibilityResult, EligibleCollateralSpecification specification, EligibilityQuery query) {
            eligibilityResult.setIsEligible(ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)MapperC.of((List)this.matchingEligibleCriteria(specification, query).getMulti()).resultCount()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).get());
            eligibilityResult.setEligibilityQuery((EligibilityQuery)MapperS.of((Object)query).get());
            eligibilityResult.setSpecification((EligibleCollateralSpecification)MapperS.of((Object)specification).get());
            eligibilityResult.addMatchingEligibleCriteria(MapperC.of((List)this.matchingEligibleCriteria(specification, query).getMulti()).getMulti());
            return Optional.ofNullable(eligibilityResult).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends EligibleCollateralCriteria> matchingEligibleCriteria(EligibleCollateralSpecification specification, EligibilityQuery query) {
            return (Mapper)((MapperC)MapperS.of((Object)specification).mapC("getCriteria", eligibleCollateralSpecification -> eligibleCollateralSpecification.getCriteria()).filterItemNullSafe(item -> (Boolean)item.map("getTreatment", eligibleCollateralCriteria -> eligibleCollateralCriteria.getTreatment()).map("getIsIncluded", collateralTreatment -> collateralTreatment.getIsIncluded()).get()).apply(item -> item.filterItemNullSafe(_item -> (Boolean)((MapperS)((MapperC)((MapperC)((MapperC)((MapperC)((MapperC)_item.mapC("getAsset", collateralCriteriaBase -> collateralCriteriaBase.getAsset()).apply(__item -> __item.filterItemNullSafe(___item -> (Boolean)MapperS.of((Object)this.checkAssetCountryOfOrigin.evaluate(___item.mapC("getAssetCountryOfOrigin", assetCriteria -> assetCriteria.getAssetCountryOfOrigin()).getMulti(), (EligibilityQuery)MapperS.of((Object)query).get())).get()))).apply(__item -> __item.filterItemNullSafe(___item -> (Boolean)MapperS.of((Object)this.checkAgencyRating.evaluate(___item.mapC("getAgencyRating", assetCriteria -> assetCriteria.getAgencyRating()).getMulti(), (EligibilityQuery)MapperS.of((Object)query).get())).get()))).apply(__item -> __item.filterItemNullSafe(___item -> (Boolean)MapperS.of((Object)this.checkAssetType.evaluate(___item.mapC("getCollateralAssetType", assetCriteria -> assetCriteria.getCollateralAssetType()).getMulti(), (EligibilityQuery)MapperS.of((Object)query).get())).get()))).apply(__item -> __item.filterItemNullSafe(___item -> (Boolean)MapperS.of((Object)this.checkDenominatedCurrency.evaluate(___item.mapC("getDenominatedCurrency", assetCriteria -> assetCriteria.getDenominatedCurrency()).getMulti(), (EligibilityQuery)MapperS.of((Object)query).get())).get()))).apply(__item -> __item.filterItemNullSafe(___item -> (Boolean)MapperS.of((Object)this.checkMaturity.evaluate((PeriodRange)___item.map("getMaturityRange", assetCriteria -> assetCriteria.getMaturityRange()).get(), (EligibilityQuery)MapperS.of((Object)query).get())).get()))).apply(__item -> ExpressionOperators.exists((Mapper)__item).asMapper())).get()))).apply(item -> item.filterItemNullSafe(_item -> (Boolean)((MapperS)((MapperC)((MapperC)_item.mapC("getIssuer", collateralCriteriaBase -> collateralCriteriaBase.getIssuer()).apply(__item -> __item.filterItemNullSafe(___item -> (Boolean)MapperS.of((Object)this.checkIssuerName.evaluate(___item.mapC("getIssuerName", issuerCriteria -> issuerCriteria.getIssuerName()).getMulti(), (EligibilityQuery)MapperS.of((Object)query).get())).get()))).apply(__item -> __item.filterItemNullSafe(___item -> (Boolean)MapperS.of((Object)this.checkIssuerType.evaluate(___item.mapC("getIssuerType", issuerCriteria -> issuerCriteria.getIssuerType()).getMulti(), (EligibilityQuery)MapperS.of((Object)query).get())).get()))).apply(__item -> ExpressionOperators.exists((Mapper)__item).asMapper())).get()));
        }
    }
}

