/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="InterestRatePayoutFpML_ird_6")
@ImplementedBy(value=Default.class)
public interface InterestRatePayoutFpMLIrd6
extends Validator<InterestRatePayout> {
    public static final String NAME = "InterestRatePayoutFpML_ird_6";
    public static final String DEFINITION = "if paymentDates -> firstPaymentDate exists and calculationPeriodDates -> effectiveDate exists then paymentDates -> firstPaymentDate > calculationPeriodDates -> effectiveDate -> adjustableDate -> unadjustedDate";

    public ValidationResult<InterestRatePayout> validate(RosettaPath var1, InterestRatePayout var2);

    public static class NoOp
    implements InterestRatePayoutFpMLIrd6 {
        @Override
        public ValidationResult<InterestRatePayout> validate(RosettaPath path, InterestRatePayout interestRatePayout) {
            return ValidationResult.success((String)InterestRatePayoutFpMLIrd6.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutFpMLIrd6.DEFINITION);
        }
    }

    public static class Default
    implements InterestRatePayoutFpMLIrd6 {
        @Override
        public ValidationResult<InterestRatePayout> validate(RosettaPath path, InterestRatePayout interestRatePayout) {
            ComparisonResult result = this.executeDataRule(interestRatePayout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)InterestRatePayoutFpMLIrd6.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutFpMLIrd6.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition InterestRatePayoutFpML_ird_6 failed.";
            }
            return ValidationResult.failure((String)InterestRatePayoutFpMLIrd6.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"InterestRatePayout", (RosettaPath)path, (String)InterestRatePayoutFpMLIrd6.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(InterestRatePayout interestRatePayout) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getPaymentDates", _interestRatePayout -> _interestRatePayout.getPaymentDates()).map("getFirstPaymentDate", paymentDates -> paymentDates.getFirstPaymentDate())).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)interestRatePayout).map("getCalculationPeriodDates", _interestRatePayout -> _interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)interestRatePayout).map("getPaymentDates", _interestRatePayout -> _interestRatePayout.getPaymentDates()).map("getFirstPaymentDate", paymentDates -> paymentDates.getFirstPaymentDate()), (Mapper)MapperS.of((Object)interestRatePayout).map("getCalculationPeriodDates", _interestRatePayout -> _interestRatePayout.getCalculationPeriodDates()).map("getEffectiveDate", calculationPeriodDates -> calculationPeriodDates.getEffectiveDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).map("getUnadjustedDate", adjustableDate -> adjustableDate.getUnadjustedDate()), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

