/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.CommodityPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="CommodityPayoutQuantity")
@ImplementedBy(value=Default.class)
public interface CommodityPayoutQuantity
extends Validator<CommodityPayout> {
    public static final String NAME = "CommodityPayoutQuantity";
    public static final String DEFINITION = "priceQuantity exists";

    public ValidationResult<CommodityPayout> validate(RosettaPath var1, CommodityPayout var2);

    public static class NoOp
    implements CommodityPayoutQuantity {
        @Override
        public ValidationResult<CommodityPayout> validate(RosettaPath path, CommodityPayout commodityPayout) {
            return ValidationResult.success((String)CommodityPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityPayout", (RosettaPath)path, (String)CommodityPayoutQuantity.DEFINITION);
        }
    }

    public static class Default
    implements CommodityPayoutQuantity {
        @Override
        public ValidationResult<CommodityPayout> validate(RosettaPath path, CommodityPayout commodityPayout) {
            ComparisonResult result = this.executeDataRule(commodityPayout);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)CommodityPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityPayout", (RosettaPath)path, (String)CommodityPayoutQuantity.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition CommodityPayoutQuantity failed.";
            }
            return ValidationResult.failure((String)CommodityPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CommodityPayout", (RosettaPath)path, (String)CommodityPayoutQuantity.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(CommodityPayout commodityPayout) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)commodityPayout).map("getPriceQuantity", payoutBase -> payoutBase.getPriceQuantity()));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

