/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.floatingrate.functions;

import cdm.product.asset.floatingrate.FloatingRateProcessingParameters;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.math.BigDecimal;

@ImplementedBy(value=ApplyCapsAndFloorsDefault.class)
public abstract class ApplyCapsAndFloors
implements RosettaFunction {
    public BigDecimal evaluate(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
        BigDecimal cappedAndFlooredRate = this.doEvaluate(processing, inputRate);
        return cappedAndFlooredRate;
    }

    protected abstract BigDecimal doEvaluate(FloatingRateProcessingParameters var1, BigDecimal var2);

    protected abstract Mapper<BigDecimal> cap(FloatingRateProcessingParameters var1, BigDecimal var2);

    protected abstract Mapper<BigDecimal> floor(FloatingRateProcessingParameters var1, BigDecimal var2);

    protected abstract Mapper<BigDecimal> cappedRate(FloatingRateProcessingParameters var1, BigDecimal var2);

    protected abstract Mapper<BigDecimal> flooredRate(FloatingRateProcessingParameters var1, BigDecimal var2);

    public static class ApplyCapsAndFloorsDefault
    extends ApplyCapsAndFloors {
        @Override
        protected BigDecimal doEvaluate(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            BigDecimal cappedAndFlooredRate = null;
            return this.assignOutput(cappedAndFlooredRate, processing, inputRate);
        }

        protected BigDecimal assignOutput(BigDecimal cappedAndFlooredRate, FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            cappedAndFlooredRate = (BigDecimal)MapperS.of((Object)((BigDecimal)this.flooredRate(processing, inputRate).get())).get();
            return cappedAndFlooredRate;
        }

        @Override
        protected Mapper<BigDecimal> cap(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            return MapperS.of((Object)processing).map("getCapRate", floatingRateProcessingParameters -> floatingRateProcessingParameters.getCapRate());
        }

        @Override
        protected Mapper<BigDecimal> floor(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            return MapperS.of((Object)processing).map("getFloorRate", floatingRateProcessingParameters -> floatingRateProcessingParameters.getFloorRate());
        }

        @Override
        protected Mapper<BigDecimal> cappedRate(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.cap(processing, inputRate).get()))).and(ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)inputRate), (Mapper)MapperS.of((Object)((BigDecimal)this.cap(processing, inputRate).get())), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((BigDecimal)this.cap(processing, inputRate).get()));
                }
                return MapperS.of((Object)inputRate);
            });
        }

        @Override
        protected Mapper<BigDecimal> flooredRate(FloatingRateProcessingParameters processing, BigDecimal inputRate) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((BigDecimal)this.floor(processing, inputRate).get()))).and(ExpressionOperators.lessThan((Mapper)MapperS.of((Object)((BigDecimal)this.cappedRate(processing, inputRate).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.floor(processing, inputRate).get())), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((BigDecimal)this.floor(processing, inputRate).get()));
                }
                return MapperS.of((Object)((BigDecimal)this.cappedRate(processing, inputRate).get()));
            });
        }
    }
}

