/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.math.Quantity;
import cdm.base.staticdata.identifier.LocationIdentifier;
import cdm.product.asset.AssetDeliveryPeriods;
import cdm.product.asset.meta.AssetDeliveryInformationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AssetDeliveryInformation", builder=AssetDeliveryInformationBuilderImpl.class, version="5.0.0")
public interface AssetDeliveryInformation
extends RosettaModelObject {
    public static final AssetDeliveryInformationMeta metaData = new AssetDeliveryInformationMeta();

    public AssetDeliveryPeriods getPeriods();

    public List<? extends LocationIdentifier> getLocation();

    public Quantity getDeliveryCapacity();

    public AssetDeliveryInformation build();

    public AssetDeliveryInformationBuilder toBuilder();

    public static AssetDeliveryInformationBuilder builder() {
        return new AssetDeliveryInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends AssetDeliveryInformation> metaData() {
        return metaData;
    }

    default public Class<? extends AssetDeliveryInformation> getType() {
        return AssetDeliveryInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periods"), processor, AssetDeliveryPeriods.class, this.getPeriods(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("location"), processor, LocationIdentifier.class, this.getLocation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryCapacity"), processor, Quantity.class, this.getDeliveryCapacity(), new AttributeMeta[0]);
    }

    public static class AssetDeliveryInformationBuilderImpl
    implements AssetDeliveryInformationBuilder {
        protected AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder periods;
        protected List<LocationIdentifier.LocationIdentifierBuilder> location = new ArrayList<LocationIdentifier.LocationIdentifierBuilder>();
        protected Quantity.QuantityBuilder deliveryCapacity;

        @Override
        @RosettaAttribute(value="periods")
        public AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder getPeriods() {
            return this.periods;
        }

        @Override
        public AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder getOrCreatePeriods() {
            AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder result = this.periods != null ? this.periods : (this.periods = AssetDeliveryPeriods.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="location")
        public List<? extends LocationIdentifier.LocationIdentifierBuilder> getLocation() {
            return this.location;
        }

        @Override
        public LocationIdentifier.LocationIdentifierBuilder getOrCreateLocation(int _index) {
            if (this.location == null) {
                this.location = new ArrayList<LocationIdentifier.LocationIdentifierBuilder>();
            }
            return (LocationIdentifier.LocationIdentifierBuilder)this.getIndex(this.location, _index, () -> {
                LocationIdentifier.LocationIdentifierBuilder newLocation = LocationIdentifier.builder();
                return newLocation;
            });
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        public Quantity.QuantityBuilder getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        public Quantity.QuantityBuilder getOrCreateDeliveryCapacity() {
            Quantity.QuantityBuilder result = this.deliveryCapacity != null ? this.deliveryCapacity : (this.deliveryCapacity = Quantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="periods")
        public AssetDeliveryInformationBuilder setPeriods(AssetDeliveryPeriods periods) {
            this.periods = periods == null ? null : periods.toBuilder();
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder addLocation(LocationIdentifier location) {
            if (location != null) {
                this.location.add(location.toBuilder());
            }
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder addLocation(LocationIdentifier location, int _idx) {
            this.getIndex(this.location, _idx, () -> location.toBuilder());
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder addLocation(List<? extends LocationIdentifier> locations) {
            if (locations != null) {
                for (LocationIdentifier locationIdentifier : locations) {
                    this.location.add(locationIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="location")
        public AssetDeliveryInformationBuilder setLocation(List<? extends LocationIdentifier> locations) {
            this.location = locations == null ? new ArrayList<LocationIdentifier.LocationIdentifierBuilder>() : (List)locations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        public AssetDeliveryInformationBuilder setDeliveryCapacity(Quantity deliveryCapacity) {
            this.deliveryCapacity = deliveryCapacity == null ? null : deliveryCapacity.toBuilder();
            return this;
        }

        @Override
        public AssetDeliveryInformation build() {
            return new AssetDeliveryInformationImpl(this);
        }

        @Override
        public AssetDeliveryInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder prune() {
            if (this.periods != null && !this.periods.prune().hasData()) {
                this.periods = null;
            }
            this.location = this.location.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.deliveryCapacity != null && !this.deliveryCapacity.prune().hasData()) {
                this.deliveryCapacity = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPeriods() != null && this.getPeriods().hasData()) {
                return true;
            }
            if (this.getLocation() != null && this.getLocation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getDeliveryCapacity() != null && this.getDeliveryCapacity().hasData();
        }

        public AssetDeliveryInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AssetDeliveryInformationBuilder o = (AssetDeliveryInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriods(), (RosettaModelObjectBuilder)o.getPeriods(), this::setPeriods);
            merger.mergeRosetta(this.getLocation(), o.getLocation(), this::getOrCreateLocation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDeliveryCapacity(), (RosettaModelObjectBuilder)o.getDeliveryCapacity(), this::setDeliveryCapacity);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.periods, _that.getPeriods())) {
                return false;
            }
            if (!ListEquals.listEquals(this.location, _that.getLocation())) {
                return false;
            }
            return Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periods != null ? this.periods.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryInformationBuilder {periods=" + this.periods + ", location=" + this.location + ", deliveryCapacity=" + this.deliveryCapacity + '}';
        }
    }

    public static class AssetDeliveryInformationImpl
    implements AssetDeliveryInformation {
        private final AssetDeliveryPeriods periods;
        private final List<? extends LocationIdentifier> location;
        private final Quantity deliveryCapacity;

        protected AssetDeliveryInformationImpl(AssetDeliveryInformationBuilder builder) {
            this.periods = Optional.ofNullable(builder.getPeriods()).map(f -> f.build()).orElse(null);
            this.location = Optional.ofNullable(builder.getLocation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.deliveryCapacity = Optional.ofNullable(builder.getDeliveryCapacity()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periods")
        public AssetDeliveryPeriods getPeriods() {
            return this.periods;
        }

        @Override
        @RosettaAttribute(value="location")
        public List<? extends LocationIdentifier> getLocation() {
            return this.location;
        }

        @Override
        @RosettaAttribute(value="deliveryCapacity")
        public Quantity getDeliveryCapacity() {
            return this.deliveryCapacity;
        }

        @Override
        public AssetDeliveryInformation build() {
            return this;
        }

        @Override
        public AssetDeliveryInformationBuilder toBuilder() {
            AssetDeliveryInformationBuilder builder = AssetDeliveryInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AssetDeliveryInformationBuilder builder) {
            Optional.ofNullable(this.getPeriods()).ifPresent(builder::setPeriods);
            Optional.ofNullable(this.getLocation()).ifPresent(builder::setLocation);
            Optional.ofNullable(this.getDeliveryCapacity()).ifPresent(builder::setDeliveryCapacity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AssetDeliveryInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.periods, _that.getPeriods())) {
                return false;
            }
            if (!ListEquals.listEquals(this.location, _that.getLocation())) {
                return false;
            }
            return Objects.equals(this.deliveryCapacity, _that.getDeliveryCapacity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.periods != null ? this.periods.hashCode() : 0);
            _result = 31 * _result + (this.location != null ? this.location.hashCode() : 0);
            _result = 31 * _result + (this.deliveryCapacity != null ? this.deliveryCapacity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AssetDeliveryInformation {periods=" + this.periods + ", location=" + this.location + ", deliveryCapacity=" + this.deliveryCapacity + '}';
        }
    }

    public static interface AssetDeliveryInformationBuilder
    extends AssetDeliveryInformation,
    RosettaModelObjectBuilder {
        public AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder getOrCreatePeriods();

        @Override
        public AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder getPeriods();

        public LocationIdentifier.LocationIdentifierBuilder getOrCreateLocation(int var1);

        public List<? extends LocationIdentifier.LocationIdentifierBuilder> getLocation();

        public Quantity.QuantityBuilder getOrCreateDeliveryCapacity();

        @Override
        public Quantity.QuantityBuilder getDeliveryCapacity();

        public AssetDeliveryInformationBuilder setPeriods(AssetDeliveryPeriods var1);

        public AssetDeliveryInformationBuilder addLocation(LocationIdentifier var1);

        public AssetDeliveryInformationBuilder addLocation(LocationIdentifier var1, int var2);

        public AssetDeliveryInformationBuilder addLocation(List<? extends LocationIdentifier> var1);

        public AssetDeliveryInformationBuilder setLocation(List<? extends LocationIdentifier> var1);

        public AssetDeliveryInformationBuilder setDeliveryCapacity(Quantity var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periods"), processor, AssetDeliveryPeriods.AssetDeliveryPeriodsBuilder.class, this.getPeriods(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("location"), processor, LocationIdentifier.LocationIdentifierBuilder.class, this.getLocation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryCapacity"), processor, Quantity.QuantityBuilder.class, this.getDeliveryCapacity(), new AttributeMeta[0]);
        }

        public AssetDeliveryInformationBuilder prune();
    }
}

