/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.ValuationMethod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="ValuationMethodDealer")
@ImplementedBy(value=Default.class)
public interface ValuationMethodDealer
extends Validator<ValuationMethod> {
    public static final String NAME = "ValuationMethodDealer";
    public static final String DEFINITION = "if quotationAmount exists or minimumQuotationAmount exists then valuationSource -> dealerOrCCP -> legalEntity exists";

    public ValidationResult<ValuationMethod> validate(RosettaPath var1, ValuationMethod var2);

    public static class NoOp
    implements ValuationMethodDealer {
        @Override
        public ValidationResult<ValuationMethod> validate(RosettaPath path, ValuationMethod valuationMethod) {
            return ValidationResult.success((String)ValuationMethodDealer.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationMethod", (RosettaPath)path, (String)ValuationMethodDealer.DEFINITION);
        }
    }

    public static class Default
    implements ValuationMethodDealer {
        @Override
        public ValidationResult<ValuationMethod> validate(RosettaPath path, ValuationMethod valuationMethod) {
            ComparisonResult result = this.executeDataRule(valuationMethod);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ValuationMethodDealer.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationMethod", (RosettaPath)path, (String)ValuationMethodDealer.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ValuationMethodDealer failed.";
            }
            return ValidationResult.failure((String)ValuationMethodDealer.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ValuationMethod", (RosettaPath)path, (String)ValuationMethodDealer.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(ValuationMethod valuationMethod) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)valuationMethod).map("getQuotationAmount", _valuationMethod -> _valuationMethod.getQuotationAmount())).or(ExpressionOperators.exists((Mapper)MapperS.of((Object)valuationMethod).map("getMinimumQuotationAmount", _valuationMethod -> _valuationMethod.getMinimumQuotationAmount()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.exists((Mapper)MapperS.of((Object)valuationMethod).map("getValuationSource", _valuationMethod -> _valuationMethod.getValuationSource()).map("getDealerOrCCP", valuationSource -> valuationSource.getDealerOrCCP()).map("getLegalEntity", ancillaryEntity -> ancillaryEntity.getLegalEntity()));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

