/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="PriceScheduleArithmeticOperator")
@ImplementedBy(value=Default.class)
public interface PriceScheduleArithmeticOperator
extends Validator<PriceSchedule> {
    public static final String NAME = "PriceScheduleArithmeticOperator";
    public static final String DEFINITION = "arithmeticOperator <> ArithmeticOperationEnum -> Subtract and arithmeticOperator <> ArithmeticOperationEnum -> Divide";

    public ValidationResult<PriceSchedule> validate(RosettaPath var1, PriceSchedule var2);

    public static class NoOp
    implements PriceScheduleArithmeticOperator {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            return ValidationResult.success((String)PriceScheduleArithmeticOperator.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleArithmeticOperator.DEFINITION);
        }
    }

    public static class Default
    implements PriceScheduleArithmeticOperator {
        @Override
        public ValidationResult<PriceSchedule> validate(RosettaPath path, PriceSchedule priceSchedule) {
            ComparisonResult result = this.executeDataRule(priceSchedule);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)PriceScheduleArithmeticOperator.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleArithmeticOperator.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition PriceScheduleArithmeticOperator failed.";
            }
            return ValidationResult.failure((String)PriceScheduleArithmeticOperator.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PriceSchedule", (RosettaPath)path, (String)PriceScheduleArithmeticOperator.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(PriceSchedule priceSchedule) {
            try {
                ComparisonResult result = ExpressionOperators.notEqual((Mapper)MapperS.of((Object)priceSchedule).map("getArithmeticOperator", _priceSchedule -> _priceSchedule.getArithmeticOperator()), (Mapper)MapperS.of((Object)((Object)ArithmeticOperationEnum.SUBTRACT)), (CardinalityOperator)CardinalityOperator.Any).and(ExpressionOperators.notEqual((Mapper)MapperS.of((Object)priceSchedule).map("getArithmeticOperator", _priceSchedule -> _priceSchedule.getArithmeticOperator()), (Mapper)MapperS.of((Object)((Object)ArithmeticOperationEnum.DIVIDE)), (CardinalityOperator)CardinalityOperator.Any));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

