/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.validation.datarule;

import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="MoneyCurrencyUnitExists")
@ImplementedBy(value=Default.class)
public interface MoneyCurrencyUnitExists
extends Validator<Money> {
    public static final String NAME = "MoneyCurrencyUnitExists";
    public static final String DEFINITION = "unit -> currency exists";

    public ValidationResult<Money> validate(RosettaPath var1, Money var2);

    public static class NoOp
    implements MoneyCurrencyUnitExists {
        @Override
        public ValidationResult<Money> validate(RosettaPath path, Money money) {
            return ValidationResult.success((String)MoneyCurrencyUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Money", (RosettaPath)path, (String)MoneyCurrencyUnitExists.DEFINITION);
        }
    }

    public static class Default
    implements MoneyCurrencyUnitExists {
        @Override
        public ValidationResult<Money> validate(RosettaPath path, Money money) {
            ComparisonResult result = this.executeDataRule(money);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)MoneyCurrencyUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Money", (RosettaPath)path, (String)MoneyCurrencyUnitExists.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition MoneyCurrencyUnitExists failed.";
            }
            return ValidationResult.failure((String)MoneyCurrencyUnitExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Money", (RosettaPath)path, (String)MoneyCurrencyUnitExists.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Money money) {
            try {
                ComparisonResult result = ExpressionOperators.exists((Mapper)MapperS.of((Object)money).map("getUnit", measureBase -> measureBase.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).map("getValue", _f -> _f.getValue()));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

