/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.daycount.DayCountFractionEnum;
import cdm.base.datetime.daycount.functions.YearFractionForOneDay;
import cdm.observable.asset.FloatingRateOption;
import cdm.observable.asset.calculatedrate.CalculatedRateDetails;
import cdm.observable.asset.calculatedrate.CalculatedRateObservationDatesAndWeights;
import cdm.observable.asset.calculatedrate.CalculationMethodEnum;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.functions.ApplyAveragingFormula;
import cdm.observable.asset.calculatedrate.functions.ApplyCompoundingFormula;
import cdm.observable.asset.calculatedrate.functions.GenerateObservationDatesAndWeights;
import cdm.observable.asset.calculatedrate.functions.ProcessObservations;
import cdm.observable.asset.fro.functions.IndexValueObservationMultiple;
import cdm.product.asset.floatingrate.FloatingRateSettingDetails;
import cdm.product.common.schedule.CalculationPeriodBase;
import cdm.product.common.schedule.ResetDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=EvaluateCalculatedRateDefault.class)
public abstract class EvaluateCalculatedRate
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ApplyAveragingFormula applyAveragingFormula;
    @Inject
    protected ApplyCompoundingFormula applyCompoundingFormula;
    @Inject
    protected GenerateObservationDatesAndWeights generateObservationDatesAndWeights;
    @Inject
    protected IndexValueObservationMultiple indexValueObservationMultiple;
    @Inject
    protected ProcessObservations processObservations;
    @Inject
    protected YearFractionForOneDay yearFractionForOneDay;

    public FloatingRateSettingDetails evaluate(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
        FloatingRateSettingDetails results;
        FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder resultsBuilder = this.doEvaluate(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount);
        if (resultsBuilder == null) {
            results = null;
        } else {
            results = resultsBuilder.build();
            this.objectValidator.validate(FloatingRateSettingDetails.class, (RosettaModelObject)results);
        }
        return results;
    }

    protected abstract FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<? extends FloatingRateOption> fro(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<? extends CalculatedRateObservationDatesAndWeights> datesAndWeights(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<Date> observationDates(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<BigDecimal> observations(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<BigDecimal> processedObservations(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<CalculationMethodEnum> calculationMethod(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<Boolean> isCompounding(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<BigDecimal> weights(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<BigDecimal> yearFraction(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    protected abstract Mapper<? extends CalculatedRateDetails> calculationResults(FloatingRateOption var1, FloatingRateCalculationParameters var2, ResetDates var3, CalculationPeriodBase var4, CalculationPeriodBase var5, DayCountFractionEnum var6);

    public static class EvaluateCalculatedRateDefault
    extends EvaluateCalculatedRate {
        @Override
        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder doEvaluate(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder results = FloatingRateSettingDetails.builder();
            return this.assignOutput(results, floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount);
        }

        protected FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder assignOutput(FloatingRateSettingDetails.FloatingRateSettingDetailsBuilder results, FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            results.setCalculationDetails((CalculatedRateDetails)MapperS.of((Object)((CalculatedRateDetails)this.calculationResults(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())).get());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addObservationDates(MapperS.of((Object)((CalculatedRateObservationDatesAndWeights)this.datesAndWeights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())).mapC("getObservationDates", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getObservationDates()).getMulti());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addWeights(MapperS.of((Object)((CalculatedRateObservationDatesAndWeights)this.datesAndWeights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())).mapC("getWeights", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getWeights()).getMulti());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addObservedRates(MapperC.of((List)this.observations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()).getMulti());
            results.getOrCreateCalculationDetails().getOrCreateObservations().addProcessedRates(MapperC.of((List)this.processedObservations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()).getMulti());
            results.setFloatingRate((BigDecimal)MapperS.of((Object)((CalculatedRateDetails)this.calculationResults(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())).map("getCalculatedRate", calculatedRateDetails -> calculatedRateDetails.getCalculatedRate()).get());
            return Optional.ofNullable(results).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends FloatingRateOption> fro(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)floatingRateOption);
        }

        @Override
        protected Mapper<? extends CalculatedRateObservationDatesAndWeights> datesAndWeights(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)this.generateObservationDatesAndWeights.evaluate((FloatingRateCalculationParameters)MapperS.of((Object)calculationParameters).get(), (ResetDates)MapperS.of((Object)resetDates).get(), (CalculationPeriodBase)MapperS.of((Object)calculationPeriod).get(), (CalculationPeriodBase)MapperS.of((Object)priorCalculationPeriod).get()));
        }

        @Override
        protected Mapper<Date> observationDates(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)((CalculatedRateObservationDatesAndWeights)this.datesAndWeights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())).mapC("getObservationDates", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getObservationDates());
        }

        @Override
        protected Mapper<BigDecimal> observations(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperC.of(this.indexValueObservationMultiple.evaluate(MapperC.of((List)this.observationDates(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()).getMulti(), (FloatingRateOption)MapperS.of((Object)((FloatingRateOption)this.fro(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())).get()));
        }

        @Override
        protected Mapper<BigDecimal> processedObservations(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperC.of(this.processObservations.evaluate((FloatingRateCalculationParameters)MapperS.of((Object)calculationParameters).get(), MapperC.of((List)this.observations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()).getMulti()));
        }

        @Override
        protected Mapper<CalculationMethodEnum> calculationMethod(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)calculationParameters).map("getCalculationMethod", floatingRateCalculationParameters -> floatingRateCalculationParameters.getCalculationMethod());
        }

        @Override
        protected Mapper<Boolean> isCompounding(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)((Object)((CalculationMethodEnum)((Object)this.calculationMethod(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())))), (Mapper)MapperS.of((Object)((Object)CalculationMethodEnum.COMPOUNDING)), (CardinalityOperator)CardinalityOperator.All);
        }

        @Override
        protected Mapper<BigDecimal> weights(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)((CalculatedRateObservationDatesAndWeights)this.datesAndWeights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())).mapC("getWeights", calculatedRateObservationDatesAndWeights -> calculatedRateObservationDatesAndWeights.getWeights());
        }

        @Override
        protected Mapper<BigDecimal> yearFraction(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperS.of((Object)this.yearFractionForOneDay.evaluate((DayCountFractionEnum)((Object)MapperS.of((Object)((Object)dayCount)).get())));
        }

        @Override
        protected Mapper<? extends CalculatedRateDetails> calculationResults(FloatingRateOption floatingRateOption, FloatingRateCalculationParameters calculationParameters, ResetDates resetDates, CalculationPeriodBase calculationPeriod, CalculationPeriodBase priorCalculationPeriod, DayCountFractionEnum dayCount) {
            return MapperUtils.runSinglePolymorphic(() -> {
                if (((Boolean)MapperS.of((Object)((Boolean)this.isCompounding(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())).getOrDefault((Object)false)).booleanValue()) {
                    return MapperS.of((Object)this.applyCompoundingFormula.evaluate(MapperC.of((List)this.processedObservations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()).getMulti(), MapperC.of((List)this.weights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()).getMulti(), (BigDecimal)MapperS.of((Object)((BigDecimal)this.yearFraction(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).get())).get()));
                }
                return MapperS.of((Object)this.applyAveragingFormula.evaluate(MapperC.of((List)this.observations(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()).getMulti(), MapperC.of((List)this.weights(floatingRateOption, calculationParameters, resetDates, calculationPeriod, priorCalculationPeriod, dayCount).getMulti()).getMulti()));
            });
        }
    }
}

