/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.BusinessCenters;
import cdm.base.datetime.functions.GetAllBusinessCenters;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.ObservationShiftCalculation;
import cdm.observable.asset.calculatedrate.OffsetCalculation;
import cdm.observable.asset.calculatedrate.functions.GenerateObservationPeriod;
import cdm.product.common.schedule.CalculationPeriodBase;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=DetermineObservationPeriodDefault.class)
public abstract class DetermineObservationPeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GenerateObservationPeriod generateObservationPeriod;
    @Inject
    protected GetAllBusinessCenters getAllBusinessCenters;

    public CalculationPeriodBase evaluate(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
        CalculationPeriodBase observationPeriod;
        CalculationPeriodBase.CalculationPeriodBaseBuilder observationPeriodBuilder = this.doEvaluate(adjustedCalculationPeriod, calculationParams);
        if (observationPeriodBuilder == null) {
            observationPeriod = null;
        } else {
            observationPeriod = observationPeriodBuilder.build();
            this.objectValidator.validate(CalculationPeriodBase.class, (RosettaModelObject)observationPeriod);
        }
        return observationPeriod;
    }

    protected abstract CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract Mapper<? extends ObservationShiftCalculation> obsShift(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract Mapper<? extends OffsetCalculation> lookback(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract Mapper<? extends BusinessCenters> businessDays(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract Mapper<? extends BusinessCenters> additionalBusinessDays(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract Mapper<BusinessCenterEnum> allBusinessDays(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract Mapper<Integer> shift(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    protected abstract Mapper<Integer> shiftDefaulted(CalculationPeriodBase var1, FloatingRateCalculationParameters var2);

    public static class DetermineObservationPeriodDefault
    extends DetermineObservationPeriod {
        @Override
        protected CalculationPeriodBase.CalculationPeriodBaseBuilder doEvaluate(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            CalculationPeriodBase.CalculationPeriodBaseBuilder observationPeriod = CalculationPeriodBase.builder();
            return this.assignOutput(observationPeriod, adjustedCalculationPeriod, calculationParams);
        }

        protected CalculationPeriodBase.CalculationPeriodBaseBuilder assignOutput(CalculationPeriodBase.CalculationPeriodBaseBuilder observationPeriod, CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            observationPeriod = (CalculationPeriodBase.CalculationPeriodBaseBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.generateObservationPeriod.evaluate((CalculationPeriodBase)MapperS.of((Object)adjustedCalculationPeriod).get(), MapperC.of((List)this.allBusinessDays(adjustedCalculationPeriod, calculationParams).getMulti()).getMulti(), (Integer)MapperS.of((Object)((Integer)this.shiftDefaulted(adjustedCalculationPeriod, calculationParams).get())).get())).get());
            return Optional.ofNullable(observationPeriod).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends ObservationShiftCalculation> obsShift(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return MapperS.of((Object)calculationParams).map("getObservationShiftCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getObservationShiftCalculation());
        }

        @Override
        protected Mapper<? extends OffsetCalculation> lookback(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return MapperS.of((Object)calculationParams).map("getLookbackCalculation", floatingRateCalculationParameters -> floatingRateCalculationParameters.getLookbackCalculation());
        }

        @Override
        protected Mapper<? extends BusinessCenters> businessDays(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return MapperS.of((Object)calculationParams).map("getApplicableBusinessDays", floatingRateCalculationParameters -> floatingRateCalculationParameters.getApplicableBusinessDays());
        }

        @Override
        protected Mapper<? extends BusinessCenters> additionalBusinessDays(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return MapperS.of((Object)((ObservationShiftCalculation)this.obsShift(adjustedCalculationPeriod, calculationParams).get())).map("getAdditionalBusinessDays", observationShiftCalculation -> observationShiftCalculation.getAdditionalBusinessDays());
        }

        @Override
        protected Mapper<BusinessCenterEnum> allBusinessDays(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return (Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((BusinessCenters)this.businessDays(adjustedCalculationPeriod, calculationParams).get())), MapperS.of((Object)((BusinessCenters)this.additionalBusinessDays(adjustedCalculationPeriod, calculationParams).get()))}).mapItemToList(item -> MapperC.of(this.getAllBusinessCenters.evaluate((BusinessCenters)item.get()))).apply(item -> item.flattenList());
        }

        @Override
        protected Mapper<Integer> shift(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((ObservationShiftCalculation)this.obsShift(adjustedCalculationPeriod, calculationParams).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((ObservationShiftCalculation)this.obsShift(adjustedCalculationPeriod, calculationParams).get())).map("getOffsetDays", observationShiftCalculation -> observationShiftCalculation.getOffsetDays());
                }
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((OffsetCalculation)this.lookback(adjustedCalculationPeriod, calculationParams).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((OffsetCalculation)this.lookback(adjustedCalculationPeriod, calculationParams).get())).map("getOffsetDays", offsetCalculation -> offsetCalculation.getOffsetDays());
                }
                return MapperS.of((Object)0);
            });
        }

        @Override
        protected Mapper<Integer> shiftDefaulted(CalculationPeriodBase adjustedCalculationPeriod, FloatingRateCalculationParameters calculationParams) {
            return MapperUtils.runSingle(() -> {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)((Integer)this.shift(adjustedCalculationPeriod, calculationParams).get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Integer)this.shift(adjustedCalculationPeriod, calculationParams).get()));
                }
                return MapperS.of((Object)5);
            });
        }
    }
}

