/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.functions.VectorOperation;
import cdm.observable.asset.calculatedrate.CalculatedRateDetails;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ApplyAveragingFormulaDefault.class)
public abstract class ApplyAveragingFormula
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected VectorOperation vectorOperation;

    public CalculatedRateDetails evaluate(List<BigDecimal> observations, List<BigDecimal> weights) {
        CalculatedRateDetails results;
        CalculatedRateDetails.CalculatedRateDetailsBuilder resultsBuilder = this.doEvaluate(observations, weights);
        if (resultsBuilder == null) {
            results = null;
        } else {
            results = resultsBuilder.build();
            this.objectValidator.validate(CalculatedRateDetails.class, (RosettaModelObject)results);
        }
        return results;
    }

    protected abstract CalculatedRateDetails.CalculatedRateDetailsBuilder doEvaluate(List<BigDecimal> var1, List<BigDecimal> var2);

    protected abstract Mapper<BigDecimal> weightedObservations(List<BigDecimal> var1, List<BigDecimal> var2);

    protected abstract Mapper<BigDecimal> totalWeightedObservations(List<BigDecimal> var1, List<BigDecimal> var2);

    protected abstract Mapper<BigDecimal> totalWeight(List<BigDecimal> var1, List<BigDecimal> var2);

    protected abstract Mapper<BigDecimal> calculatedRate(List<BigDecimal> var1, List<BigDecimal> var2);

    public static class ApplyAveragingFormulaDefault
    extends ApplyAveragingFormula {
        @Override
        protected CalculatedRateDetails.CalculatedRateDetailsBuilder doEvaluate(List<BigDecimal> observations, List<BigDecimal> weights) {
            CalculatedRateDetails.CalculatedRateDetailsBuilder results = CalculatedRateDetails.builder();
            return this.assignOutput(results, observations, weights);
        }

        protected CalculatedRateDetails.CalculatedRateDetailsBuilder assignOutput(CalculatedRateDetails.CalculatedRateDetailsBuilder results, List<BigDecimal> observations, List<BigDecimal> weights) {
            results.setAggregateValue((BigDecimal)MapperS.of((Object)((BigDecimal)this.totalWeightedObservations(observations, weights).get())).get());
            results.setAggregateWeight((BigDecimal)MapperS.of((Object)((BigDecimal)this.totalWeight(observations, weights).get())).get());
            results.setCalculatedRate((BigDecimal)MapperS.of((Object)((BigDecimal)this.calculatedRate(observations, weights).get())).get());
            results.addWeightedRates(MapperC.of((List)this.weightedObservations(observations, weights).getMulti()).getMulti());
            return Optional.ofNullable(results).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<BigDecimal> weightedObservations(List<BigDecimal> observations, List<BigDecimal> weights) {
            return MapperC.of(this.vectorOperation.evaluate((ArithmeticOperationEnum)((Object)MapperS.of((Object)((Object)ArithmeticOperationEnum.MULTIPLY)).get()), MapperC.of(observations).getMulti(), MapperC.of(weights).getMulti()));
        }

        @Override
        protected Mapper<BigDecimal> totalWeightedObservations(List<BigDecimal> observations, List<BigDecimal> weights) {
            return MapperC.of((List)this.weightedObservations(observations, weights).getMulti()).sumBigDecimal();
        }

        @Override
        protected Mapper<BigDecimal> totalWeight(List<BigDecimal> observations, List<BigDecimal> weights) {
            return MapperC.of(weights).sumBigDecimal();
        }

        @Override
        protected Mapper<BigDecimal> calculatedRate(List<BigDecimal> observations, List<BigDecimal> weights) {
            return MapperMaths.divide((Mapper)MapperS.of((Object)((BigDecimal)this.totalWeightedObservations(observations, weights).get())), (Mapper)MapperS.of((Object)((BigDecimal)this.totalWeight(observations, weights).get())));
        }
    }
}

