/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="ValuationMethodEnum")
public enum ValuationMethodEnum {
    MARKET("Market"),
    HIGHEST("Highest"),
    AVERAGE_MARKET("AverageMarket"),
    AVERAGE_HIGHEST("AverageHighest"),
    BLENDED_MARKET("BlendedMarket"),
    BLENDED_HIGHEST("BlendedHighest"),
    AVERAGE_BLENDED_MARKET("AverageBlendedMarket"),
    AVERAGE_BLENDED_HIGHEST("AverageBlendedHighest");

    private static Map<String, ValuationMethodEnum> values;
    private final String rosettaName;
    private final String displayName;

    private ValuationMethodEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private ValuationMethodEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static ValuationMethodEnum fromDisplayName(String name) {
        ValuationMethodEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, ValuationMethodEnum> map = new ConcurrentHashMap<String, ValuationMethodEnum>();
        for (ValuationMethodEnum instance : ValuationMethodEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

