/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common.validation.datarule;

import cdm.legaldocumentation.common.Resource;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="ResourceResourceChoice")
@ImplementedBy(value=Default.class)
public interface ResourceResourceChoice
extends Validator<Resource> {
    public static final String NAME = "ResourceResourceChoice";
    public static final String DEFINITION = "optional choice string, url";

    public ValidationResult<Resource> validate(RosettaPath var1, Resource var2);

    public static class NoOp
    implements ResourceResourceChoice {
        @Override
        public ValidationResult<Resource> validate(RosettaPath path, Resource resource) {
            return ValidationResult.success((String)ResourceResourceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Resource", (RosettaPath)path, (String)ResourceResourceChoice.DEFINITION);
        }
    }

    public static class Default
    implements ResourceResourceChoice {
        @Override
        public ValidationResult<Resource> validate(RosettaPath path, Resource resource) {
            ComparisonResult result = this.executeDataRule(resource);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)ResourceResourceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Resource", (RosettaPath)path, (String)ResourceResourceChoice.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition ResourceResourceChoice failed.";
            }
            return ValidationResult.failure((String)ResourceResourceChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Resource", (RosettaPath)path, (String)ResourceResourceChoice.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Resource resource) {
            try {
                ComparisonResult result = ExpressionOperators.choice((Mapper)MapperS.of((Object)resource), Arrays.asList("string", "url"), (ValidationResult.ChoiceRuleValidationMethod)ValidationResult.ChoiceRuleValidationMethod.OPTIONAL);
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

