/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Trade;
import cdm.legaldocumentation.common.ContractualDefinitionsEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;

@RosettaDataRule(value="TradeFpML_cd_20")
@ImplementedBy(value=Default.class)
public interface TradeFpMLCd20
extends Validator<Trade> {
    public static final String NAME = "TradeFpML_cd_20";
    public static final String DEFINITION = "if contractDetails -> documentation -> legalAgreementIdentification -> agreementName -> contractualDefinitionsType any = ContractualDefinitionsEnum -> ISDA2003CreditDerivatives then tradableProduct -> product -> contractualProduct -> economicTerms -> payout -> creditDefaultPayout -> protectionTerms -> obligations -> notContingent is absent";

    public ValidationResult<Trade> validate(RosettaPath var1, Trade var2);

    public static class NoOp
    implements TradeFpMLCd20 {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            return ValidationResult.success((String)TradeFpMLCd20.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeFpMLCd20.DEFINITION);
        }
    }

    public static class Default
    implements TradeFpMLCd20 {
        @Override
        public ValidationResult<Trade> validate(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)TradeFpMLCd20.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeFpMLCd20.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition TradeFpML_cd_20 failed.";
            }
            return ValidationResult.failure((String)TradeFpMLCd20.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeFpMLCd20.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getLegalAgreementIdentification", legalAgreementBase -> legalAgreementBase.getLegalAgreementIdentification()).map("getAgreementName", legalAgreementIdentification -> legalAgreementIdentification.getAgreementName()).mapC("getContractualDefinitionsType", agreementName -> agreementName.getContractualDefinitionsType()).map("getValue", _f -> _f.getValue()), (Mapper)MapperS.of((Object)((Object)ContractualDefinitionsEnum.ISDA_2003_CREDIT_DERIVATIVES)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.notExists((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).mapC("getProtectionTerms", creditDefaultPayout -> creditDefaultPayout.getProtectionTerms()).map("getObligations", protectionTerms -> protectionTerms.getObligations()).map("getNotContingent", obligations -> obligations.getNotContingent()));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

