/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.event.common.Instruction;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;

@RosettaDataRule(value="InstructionExclusiveSplitPrimitive")
@ImplementedBy(value=Default.class)
public interface InstructionExclusiveSplitPrimitive
extends Validator<Instruction> {
    public static final String NAME = "InstructionExclusiveSplitPrimitive";
    public static final String DEFINITION = "if primitiveInstruction -> split exists then primitiveInstruction -> split only exists";

    public ValidationResult<Instruction> validate(RosettaPath var1, Instruction var2);

    public static class NoOp
    implements InstructionExclusiveSplitPrimitive {
        @Override
        public ValidationResult<Instruction> validate(RosettaPath path, Instruction instruction) {
            return ValidationResult.success((String)InstructionExclusiveSplitPrimitive.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionExclusiveSplitPrimitive.DEFINITION);
        }
    }

    public static class Default
    implements InstructionExclusiveSplitPrimitive {
        @Override
        public ValidationResult<Instruction> validate(RosettaPath path, Instruction instruction) {
            ComparisonResult result = this.executeDataRule(instruction);
            if (result.get().booleanValue()) {
                return ValidationResult.success((String)InstructionExclusiveSplitPrimitive.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionExclusiveSplitPrimitive.DEFINITION);
            }
            String failureMessage = result.getError();
            if (failureMessage == null) {
                failureMessage = "Condition InstructionExclusiveSplitPrimitive failed.";
            }
            return ValidationResult.failure((String)InstructionExclusiveSplitPrimitive.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Instruction", (RosettaPath)path, (String)InstructionExclusiveSplitPrimitive.DEFINITION, (String)failureMessage);
        }

        private ComparisonResult executeDataRule(Instruction instruction) {
            try {
                ComparisonResult result = MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
                    if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()).map("getSplit", primitiveInstruction -> primitiveInstruction.getSplit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperators.onlyExists(Arrays.asList(MapperS.of((Object)instruction).map("getPrimitiveInstruction", _instruction -> _instruction.getPrimitiveInstruction()).map("getSplit", primitiveInstruction -> primitiveInstruction.getSplit())));
                    }
                    return null;
                }));
                return result.get() == null ? ComparisonResult.success() : result;
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

