/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.TradeState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=FilterOpenTradeStatesDefault.class)
public abstract class FilterOpenTradeStates
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends TradeState> evaluate(List<? extends TradeState> tradeStates) {
        List openTradeStates;
        List<TradeState.TradeStateBuilder> openTradeStatesBuilder = this.doEvaluate(tradeStates);
        if (openTradeStatesBuilder == null) {
            openTradeStates = null;
        } else {
            openTradeStates = openTradeStatesBuilder.stream().map(TradeState::build).collect(Collectors.toList());
            this.objectValidator.validate(TradeState.class, openTradeStates);
        }
        return openTradeStates;
    }

    protected abstract List<TradeState.TradeStateBuilder> doEvaluate(List<? extends TradeState> var1);

    public static class FilterOpenTradeStatesDefault
    extends FilterOpenTradeStates {
        @Override
        protected List<TradeState.TradeStateBuilder> doEvaluate(List<? extends TradeState> tradeStates) {
            ArrayList<TradeState.TradeStateBuilder> openTradeStates = new ArrayList<TradeState.TradeStateBuilder>();
            return this.assignOutput(openTradeStates, tradeStates);
        }

        protected List<TradeState.TradeStateBuilder> assignOutput(List<TradeState.TradeStateBuilder> openTradeStates, List<? extends TradeState> tradeStates) {
            List addVar = this.toBuilder(MapperC.of(tradeStates).filterItemNullSafe(item -> ExpressionOperators.notExists((Mapper)item.map("getState", tradeState -> tradeState.getState()).map("getClosedState", state -> state.getClosedState())).get()).getMulti());
            openTradeStates.addAll(addVar);
            return Optional.ofNullable(openTradeStates).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

