/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.position.PositionStatusEnum;
import cdm.observable.asset.PriceTypeEnum;
import cdm.product.common.NotionalAdjustmentEnum;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.functions.UpdateAmountForEachMatchingQuantity;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import cdm.product.template.functions.AddTradeLot;
import cdm.product.template.functions.FilterTradeLot;
import cdm.product.template.functions.MergeTradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.mapper.MapperUtils;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_QuantityChangeDefault.class)
public abstract class Create_QuantityChange
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected AddTradeLot addTradeLot;
    @Inject
    protected FilterTradeLot filterTradeLot;
    @Inject
    protected MergeTradeLot mergeTradeLot;
    @Inject
    protected UpdateAmountForEachMatchingQuantity updateAmountForEachMatchingQuantity;

    public TradeState evaluate(QuantityChangeInstruction instruction, TradeState tradeState) {
        TradeState quantityChange;
        this.conditionValidator.validate(() -> MapperUtils.toComparisonResult((Mapper)MapperUtils.runSingle(() -> {
            if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).map("getDirection", quantityChangeInstruction -> quantityChangeInstruction.getDirection()), (Mapper)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.DECREASE)), (CardinalityOperator)CardinalityOperator.All).and(ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).mapC("getChange", quantityChangeInstruction -> quantityChangeInstruction.getChange()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).mapC("getChange", quantityChangeInstruction -> quantityChangeInstruction.getChange()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("getValue", _f -> _f.getValue()).map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), (Mapper)MapperS.of((Object)((Object)PriceTypeEnum.CASH_PRICE)), (CardinalityOperator)CardinalityOperator.All);
            }
            return null;
        })), "Only termination where the termination price is specified as a cash price is supported for now.");
        TradeState.TradeStateBuilder quantityChangeBuilder = this.doEvaluate(instruction, tradeState);
        if (quantityChangeBuilder == null) {
            quantityChange = null;
        } else {
            quantityChange = quantityChangeBuilder.build();
            this.objectValidator.validate(TradeState.class, (RosettaModelObject)quantityChange);
        }
        return quantityChange;
    }

    protected abstract TradeState.TradeStateBuilder doEvaluate(QuantityChangeInstruction var1, TradeState var2);

    protected abstract Mapper<? extends TradableProduct> tradableProduct(QuantityChangeInstruction var1, TradeState var2);

    protected abstract Mapper<? extends TradeLot> tradeLot(QuantityChangeInstruction var1, TradeState var2);

    protected abstract Mapper<? extends PriceQuantity> newPriceQuantity(QuantityChangeInstruction var1, TradeState var2);

    protected abstract Mapper<? extends TradeLot> newTradeLots(QuantityChangeInstruction var1, TradeState var2);

    public static class Create_QuantityChangeDefault
    extends Create_QuantityChange {
        @Override
        protected TradeState.TradeStateBuilder doEvaluate(QuantityChangeInstruction instruction, TradeState tradeState) {
            TradeState.TradeStateBuilder quantityChange = TradeState.builder();
            return this.assignOutput(quantityChange, instruction, tradeState);
        }

        protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder quantityChange, QuantityChangeInstruction instruction, TradeState tradeState) {
            quantityChange = (TradeState.TradeStateBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)tradeState).get());
            quantityChange.getOrCreateTrade().setTradableProduct((TradableProduct)MapperS.of((Object)TradableProduct.builder().setProduct((Product)MapperS.of((Object)((TradableProduct)this.tradableProduct(instruction, tradeState).get())).map("getProduct", _tradableProduct -> _tradableProduct.getProduct()).get()).setTradeLot(MapperC.of((List)this.newTradeLots(instruction, tradeState).getMulti()).getMulti()).setCounterparty(MapperS.of((Object)((TradableProduct)this.tradableProduct(instruction, tradeState).get())).mapC("getCounterparty", _tradableProduct -> _tradableProduct.getCounterparty()).getMulti()).setAncillaryParty(MapperS.of((Object)((TradableProduct)this.tradableProduct(instruction, tradeState).get())).mapC("getAncillaryParty", _tradableProduct -> _tradableProduct.getAncillaryParty()).getMulti()).setAdjustment((NotionalAdjustmentEnum)((Object)MapperS.of((Object)((TradableProduct)this.tradableProduct(instruction, tradeState).get())).map("getAdjustment", _tradableProduct -> _tradableProduct.getAdjustment()).get())).build()).get());
            quantityChange.getOrCreateState().setPositionState((PositionStatusEnum)((Object)MapperUtils.runSingle(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperC.of((List)this.newTradeLots(instruction, tradeState).getMulti()).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()).map("getValue", _f -> _f.getValue()).map("getValue", measureBase -> measureBase.getValue()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)PositionStatusEnum.CLOSED));
                }
                return null;
            }).get()));
            return Optional.ofNullable(quantityChange).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected Mapper<? extends TradableProduct> tradableProduct(QuantityChangeInstruction instruction, TradeState tradeState) {
            return MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct());
        }

        @Override
        protected Mapper<? extends TradeLot> tradeLot(QuantityChangeInstruction instruction, TradeState tradeState) {
            return MapperUtils.runSinglePolymorphic(() -> {
                if (ExpressionOperators.notEqual((Mapper)MapperS.of((Object)instruction).map("getDirection", quantityChangeInstruction -> quantityChangeInstruction.getDirection()), (Mapper)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.INCREASE)), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperUtils.runSinglePolymorphic(() -> {
                        if (ExpressionOperators.exists((Mapper)MapperS.of((Object)instruction).mapC("getLotIdentifier", quantityChangeInstruction -> quantityChangeInstruction.getLotIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                            return MapperS.of((Object)((TradeLot)MapperC.of(this.filterTradeLot.evaluate(MapperS.of((Object)((TradableProduct)this.tradableProduct(instruction, tradeState).get())).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).getMulti(), MapperS.of((Object)instruction).mapC("getLotIdentifier", quantityChangeInstruction -> quantityChangeInstruction.getLotIdentifier()).getMulti())).get()));
                        }
                        return MapperS.of((Object)((TradeLot)MapperS.of((Object)((TradableProduct)this.tradableProduct(instruction, tradeState).get())).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).get()));
                    });
                }
                return null;
            });
        }

        @Override
        protected Mapper<? extends PriceQuantity> newPriceQuantity(QuantityChangeInstruction instruction, TradeState tradeState) {
            return MapperUtils.runMultiPolymorphic(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).map("getDirection", quantityChangeInstruction -> quantityChangeInstruction.getDirection()), (Mapper)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.INCREASE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)instruction).mapC("getChange", quantityChangeInstruction -> quantityChangeInstruction.getChange());
                }
                return MapperC.of(this.updateAmountForEachMatchingQuantity.evaluate(MapperS.of((Object)((TradeLot)this.tradeLot(instruction, tradeState).get())).mapC("getPriceQuantity", _tradeLot -> _tradeLot.getPriceQuantity()).getMulti(), MapperS.of((Object)instruction).mapC("getChange", quantityChangeInstruction -> quantityChangeInstruction.getChange()).getMulti(), (QuantityChangeDirectionEnum)((Object)((Object)MapperS.of((Object)instruction).map("getDirection", quantityChangeInstruction -> quantityChangeInstruction.getDirection()).get()))));
            });
        }

        @Override
        protected Mapper<? extends TradeLot> newTradeLots(QuantityChangeInstruction instruction, TradeState tradeState) {
            return MapperUtils.runMultiPolymorphic(() -> {
                if (ExpressionOperators.areEqual((Mapper)MapperS.of((Object)instruction).map("getDirection", quantityChangeInstruction -> quantityChangeInstruction.getDirection()), (Mapper)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.INCREASE)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.addTradeLot.evaluate((TradableProduct)MapperS.of((Object)((TradableProduct)this.tradableProduct(instruction, tradeState).get())).get(), (TradeLot)MapperS.of((Object)TradeLot.builder().setLotIdentifier(MapperS.of((Object)instruction).mapC("getLotIdentifier", quantityChangeInstruction -> quantityChangeInstruction.getLotIdentifier()).getMulti()).setPriceQuantity(MapperC.of((List)this.newPriceQuantity(instruction, tradeState).getMulti()).getMulti()).build()).get())).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot());
                }
                return MapperC.of(this.mergeTradeLot.evaluate(MapperS.of((Object)((TradableProduct)this.tradableProduct(instruction, tradeState).get())).mapC("getTradeLot", _tradableProduct -> _tradableProduct.getTradeLot()).getMulti(), (TradeLot)MapperS.of((Object)TradeLot.builder().setLotIdentifier(MapperS.of((Object)instruction).mapC("getLotIdentifier", quantityChangeInstruction -> quantityChangeInstruction.getLotIdentifier()).getMulti()).setPriceQuantity(MapperC.of((List)this.newPriceQuantity(instruction, tradeState).getMulti()).getMulti()).build()).get()));
            });
        }
    }
}

