/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.base.math.QuantityChangeDirectionEnum;
import cdm.event.common.PrimitiveInstruction;
import cdm.event.common.QuantityChangeInstruction;
import cdm.event.common.TermsChangeInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.functions.Create_CancellationTermChangeInstruction;
import cdm.event.common.functions.Create_TerminationInstruction;
import cdm.product.template.ContractualProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ConditionValidator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_CancellationPrimitiveInstructionDefault.class)
public abstract class Create_CancellationPrimitiveInstruction
implements RosettaFunction {
    @Inject
    protected ConditionValidator conditionValidator;
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Create_CancellationTermChangeInstruction create_CancellationTermChangeInstruction;
    @Inject
    protected Create_TerminationInstruction create_TerminationInstruction;

    public PrimitiveInstruction evaluate(TradeState tradeState, BigDecimal newRepurchasePrice, AdjustableOrRelativeDate cancellationDate) {
        PrimitiveInstruction instruction;
        this.conditionValidator.validate(() -> ExpressionOperators.exists((Mapper)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct())), "If a contratual product can be cancelled.");
        PrimitiveInstruction.PrimitiveInstructionBuilder instructionBuilder = this.doEvaluate(tradeState, newRepurchasePrice, cancellationDate);
        if (instructionBuilder == null) {
            instruction = null;
        } else {
            instruction = instructionBuilder.build();
            this.objectValidator.validate(PrimitiveInstruction.class, (RosettaModelObject)instruction);
        }
        return instruction;
    }

    protected abstract PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState var1, BigDecimal var2, AdjustableOrRelativeDate var3);

    public static class Create_CancellationPrimitiveInstructionDefault
    extends Create_CancellationPrimitiveInstruction {
        @Override
        protected PrimitiveInstruction.PrimitiveInstructionBuilder doEvaluate(TradeState tradeState, BigDecimal newRepurchasePrice, AdjustableOrRelativeDate cancellationDate) {
            PrimitiveInstruction.PrimitiveInstructionBuilder instruction = PrimitiveInstruction.builder();
            return this.assignOutput(instruction, tradeState, newRepurchasePrice, cancellationDate);
        }

        protected PrimitiveInstruction.PrimitiveInstructionBuilder assignOutput(PrimitiveInstruction.PrimitiveInstructionBuilder instruction, TradeState tradeState, BigDecimal newRepurchasePrice, AdjustableOrRelativeDate cancellationDate) {
            instruction.getOrCreateSplit().setBreakdown(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)this.create_TerminationInstruction.evaluate((TradeState)MapperS.of((Object)tradeState).get()))}).getMulti());
            instruction.getOrCreateSplit().addBreakdown(MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)PrimitiveInstruction.builder().setQuantityChange((QuantityChangeInstruction)MapperS.of((Object)QuantityChangeInstruction.builder().setChange(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).getMulti()).setDirection((QuantityChangeDirectionEnum)((Object)MapperS.of((Object)((Object)QuantityChangeDirectionEnum.REPLACE)).get())).setLotIdentifier(MapperC.ofNull().getMulti()).build()).get()).setTermsChange((TermsChangeInstruction)MapperS.of((Object)this.create_CancellationTermChangeInstruction.evaluate((ContractualProduct)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).get(), (AdjustableOrRelativeDate)MapperS.of((Object)cancellationDate).get())).get()).build())}).getMulti());
            return Optional.ofNullable(instruction).map(o -> o.prune()).orElse(null);
        }
    }
}

