/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.party.Party;
import cdm.event.common.BillingRecord;
import cdm.event.common.BillingSummary;
import cdm.event.common.meta.SecurityLendingInvoiceMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="SecurityLendingInvoice", builder=SecurityLendingInvoiceBuilderImpl.class, version="5.0.0")
public interface SecurityLendingInvoice
extends RosettaModelObject,
GlobalKey {
    public static final SecurityLendingInvoiceMeta metaData = new SecurityLendingInvoiceMeta();

    public Party getSendingParty();

    public Party getReceivingParty();

    public Date getBillingStartDate();

    public Date getBillingEndDate();

    public List<? extends BillingRecord> getBillingRecord();

    public List<? extends BillingSummary> getBillingSummary();

    public MetaFields getMeta();

    public SecurityLendingInvoice build();

    public SecurityLendingInvoiceBuilder toBuilder();

    public static SecurityLendingInvoiceBuilder builder() {
        return new SecurityLendingInvoiceBuilderImpl();
    }

    default public RosettaMetaData<? extends SecurityLendingInvoice> metaData() {
        return metaData;
    }

    default public Class<? extends SecurityLendingInvoice> getType() {
        return SecurityLendingInvoice.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("billingStartDate"), Date.class, (Object)this.getBillingStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("billingEndDate"), Date.class, (Object)this.getBillingEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("sendingParty"), processor, Party.class, this.getSendingParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("receivingParty"), processor, Party.class, this.getReceivingParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("billingRecord"), processor, BillingRecord.class, this.getBillingRecord(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("billingSummary"), processor, BillingSummary.class, this.getBillingSummary(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class SecurityLendingInvoiceBuilderImpl
    implements SecurityLendingInvoiceBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Party.PartyBuilder sendingParty;
        protected Party.PartyBuilder receivingParty;
        protected Date billingStartDate;
        protected Date billingEndDate;
        protected List<BillingRecord.BillingRecordBuilder> billingRecord = new ArrayList<BillingRecord.BillingRecordBuilder>();
        protected List<BillingSummary.BillingSummaryBuilder> billingSummary = new ArrayList<BillingSummary.BillingSummaryBuilder>();
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="sendingParty")
        public Party.PartyBuilder getSendingParty() {
            return this.sendingParty;
        }

        @Override
        public Party.PartyBuilder getOrCreateSendingParty() {
            Party.PartyBuilder result = this.sendingParty != null ? this.sendingParty : (this.sendingParty = Party.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="receivingParty")
        public Party.PartyBuilder getReceivingParty() {
            return this.receivingParty;
        }

        @Override
        public Party.PartyBuilder getOrCreateReceivingParty() {
            Party.PartyBuilder result = this.receivingParty != null ? this.receivingParty : (this.receivingParty = Party.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="billingStartDate")
        public Date getBillingStartDate() {
            return this.billingStartDate;
        }

        @Override
        @RosettaAttribute(value="billingEndDate")
        public Date getBillingEndDate() {
            return this.billingEndDate;
        }

        @Override
        @RosettaAttribute(value="billingRecord")
        public List<? extends BillingRecord.BillingRecordBuilder> getBillingRecord() {
            return this.billingRecord;
        }

        @Override
        public BillingRecord.BillingRecordBuilder getOrCreateBillingRecord(int _index) {
            if (this.billingRecord == null) {
                this.billingRecord = new ArrayList<BillingRecord.BillingRecordBuilder>();
            }
            return (BillingRecord.BillingRecordBuilder)this.getIndex(this.billingRecord, _index, () -> {
                BillingRecord.BillingRecordBuilder newBillingRecord = BillingRecord.builder();
                return newBillingRecord;
            });
        }

        @Override
        @RosettaAttribute(value="billingSummary")
        public List<? extends BillingSummary.BillingSummaryBuilder> getBillingSummary() {
            return this.billingSummary;
        }

        @Override
        public BillingSummary.BillingSummaryBuilder getOrCreateBillingSummary(int _index) {
            if (this.billingSummary == null) {
                this.billingSummary = new ArrayList<BillingSummary.BillingSummaryBuilder>();
            }
            return (BillingSummary.BillingSummaryBuilder)this.getIndex(this.billingSummary, _index, () -> {
                BillingSummary.BillingSummaryBuilder newBillingSummary = BillingSummary.builder();
                return newBillingSummary;
            });
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="sendingParty")
        public SecurityLendingInvoiceBuilder setSendingParty(Party sendingParty) {
            this.sendingParty = sendingParty == null ? null : sendingParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="receivingParty")
        public SecurityLendingInvoiceBuilder setReceivingParty(Party receivingParty) {
            this.receivingParty = receivingParty == null ? null : receivingParty.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="billingStartDate")
        public SecurityLendingInvoiceBuilder setBillingStartDate(Date billingStartDate) {
            this.billingStartDate = billingStartDate == null ? null : billingStartDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="billingEndDate")
        public SecurityLendingInvoiceBuilder setBillingEndDate(Date billingEndDate) {
            this.billingEndDate = billingEndDate == null ? null : billingEndDate;
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingRecord(BillingRecord billingRecord) {
            if (billingRecord != null) {
                this.billingRecord.add(billingRecord.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingRecord(BillingRecord billingRecord, int _idx) {
            this.getIndex(this.billingRecord, _idx, () -> billingRecord.toBuilder());
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingRecord(List<? extends BillingRecord> billingRecords) {
            if (billingRecords != null) {
                for (BillingRecord billingRecord : billingRecords) {
                    this.billingRecord.add(billingRecord.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="billingRecord")
        public SecurityLendingInvoiceBuilder setBillingRecord(List<? extends BillingRecord> billingRecords) {
            this.billingRecord = billingRecords == null ? new ArrayList<BillingRecord.BillingRecordBuilder>() : (List)billingRecords.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingSummary(BillingSummary billingSummary) {
            if (billingSummary != null) {
                this.billingSummary.add(billingSummary.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingSummary(BillingSummary billingSummary, int _idx) {
            this.getIndex(this.billingSummary, _idx, () -> billingSummary.toBuilder());
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder addBillingSummary(List<? extends BillingSummary> billingSummarys) {
            if (billingSummarys != null) {
                for (BillingSummary billingSummary : billingSummarys) {
                    this.billingSummary.add(billingSummary.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="billingSummary")
        public SecurityLendingInvoiceBuilder setBillingSummary(List<? extends BillingSummary> billingSummarys) {
            this.billingSummary = billingSummarys == null ? new ArrayList<BillingSummary.BillingSummaryBuilder>() : (List)billingSummarys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        public SecurityLendingInvoiceBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public SecurityLendingInvoice build() {
            return new SecurityLendingInvoiceImpl(this);
        }

        @Override
        public SecurityLendingInvoiceBuilder toBuilder() {
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder prune() {
            if (this.sendingParty != null && !this.sendingParty.prune().hasData()) {
                this.sendingParty = null;
            }
            if (this.receivingParty != null && !this.receivingParty.prune().hasData()) {
                this.receivingParty = null;
            }
            this.billingRecord = this.billingRecord.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.billingSummary = this.billingSummary.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSendingParty() != null && this.getSendingParty().hasData()) {
                return true;
            }
            if (this.getReceivingParty() != null && this.getReceivingParty().hasData()) {
                return true;
            }
            if (this.getBillingStartDate() != null) {
                return true;
            }
            if (this.getBillingEndDate() != null) {
                return true;
            }
            if (this.getBillingRecord() != null && this.getBillingRecord().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getBillingSummary() != null && this.getBillingSummary().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public SecurityLendingInvoiceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            SecurityLendingInvoiceBuilder o = (SecurityLendingInvoiceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSendingParty(), (RosettaModelObjectBuilder)o.getSendingParty(), this::setSendingParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReceivingParty(), (RosettaModelObjectBuilder)o.getReceivingParty(), this::setReceivingParty);
            merger.mergeRosetta(this.getBillingRecord(), o.getBillingRecord(), this::getOrCreateBillingRecord);
            merger.mergeRosetta(this.getBillingSummary(), o.getBillingSummary(), this::getOrCreateBillingSummary);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getBillingStartDate(), (Object)o.getBillingStartDate(), this::setBillingStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getBillingEndDate(), (Object)o.getBillingEndDate(), this::setBillingEndDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecurityLendingInvoice _that = this.getType().cast(o);
            if (!Objects.equals(this.sendingParty, _that.getSendingParty())) {
                return false;
            }
            if (!Objects.equals(this.receivingParty, _that.getReceivingParty())) {
                return false;
            }
            if (!Objects.equals(this.billingStartDate, _that.getBillingStartDate())) {
                return false;
            }
            if (!Objects.equals(this.billingEndDate, _that.getBillingEndDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingRecord, _that.getBillingRecord())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingSummary, _that.getBillingSummary())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.sendingParty != null ? this.sendingParty.hashCode() : 0);
            _result = 31 * _result + (this.receivingParty != null ? this.receivingParty.hashCode() : 0);
            _result = 31 * _result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
            _result = 31 * _result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
            _result = 31 * _result + (this.billingRecord != null ? this.billingRecord.hashCode() : 0);
            _result = 31 * _result + (this.billingSummary != null ? this.billingSummary.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecurityLendingInvoiceBuilder {sendingParty=" + this.sendingParty + ", receivingParty=" + this.receivingParty + ", billingStartDate=" + this.billingStartDate + ", billingEndDate=" + this.billingEndDate + ", billingRecord=" + this.billingRecord + ", billingSummary=" + this.billingSummary + ", meta=" + this.meta + '}';
        }
    }

    public static class SecurityLendingInvoiceImpl
    implements SecurityLendingInvoice {
        private final Party sendingParty;
        private final Party receivingParty;
        private final Date billingStartDate;
        private final Date billingEndDate;
        private final List<? extends BillingRecord> billingRecord;
        private final List<? extends BillingSummary> billingSummary;
        private final MetaFields meta;

        protected SecurityLendingInvoiceImpl(SecurityLendingInvoiceBuilder builder) {
            this.sendingParty = Optional.ofNullable(builder.getSendingParty()).map(f -> f.build()).orElse(null);
            this.receivingParty = Optional.ofNullable(builder.getReceivingParty()).map(f -> f.build()).orElse(null);
            this.billingStartDate = builder.getBillingStartDate();
            this.billingEndDate = builder.getBillingEndDate();
            this.billingRecord = Optional.ofNullable(builder.getBillingRecord()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.billingSummary = Optional.ofNullable(builder.getBillingSummary()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="sendingParty")
        public Party getSendingParty() {
            return this.sendingParty;
        }

        @Override
        @RosettaAttribute(value="receivingParty")
        public Party getReceivingParty() {
            return this.receivingParty;
        }

        @Override
        @RosettaAttribute(value="billingStartDate")
        public Date getBillingStartDate() {
            return this.billingStartDate;
        }

        @Override
        @RosettaAttribute(value="billingEndDate")
        public Date getBillingEndDate() {
            return this.billingEndDate;
        }

        @Override
        @RosettaAttribute(value="billingRecord")
        public List<? extends BillingRecord> getBillingRecord() {
            return this.billingRecord;
        }

        @Override
        @RosettaAttribute(value="billingSummary")
        public List<? extends BillingSummary> getBillingSummary() {
            return this.billingSummary;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public SecurityLendingInvoice build() {
            return this;
        }

        @Override
        public SecurityLendingInvoiceBuilder toBuilder() {
            SecurityLendingInvoiceBuilder builder = SecurityLendingInvoice.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecurityLendingInvoiceBuilder builder) {
            Optional.ofNullable(this.getSendingParty()).ifPresent(builder::setSendingParty);
            Optional.ofNullable(this.getReceivingParty()).ifPresent(builder::setReceivingParty);
            Optional.ofNullable(this.getBillingStartDate()).ifPresent(builder::setBillingStartDate);
            Optional.ofNullable(this.getBillingEndDate()).ifPresent(builder::setBillingEndDate);
            Optional.ofNullable(this.getBillingRecord()).ifPresent(builder::setBillingRecord);
            Optional.ofNullable(this.getBillingSummary()).ifPresent(builder::setBillingSummary);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            SecurityLendingInvoice _that = this.getType().cast(o);
            if (!Objects.equals(this.sendingParty, _that.getSendingParty())) {
                return false;
            }
            if (!Objects.equals(this.receivingParty, _that.getReceivingParty())) {
                return false;
            }
            if (!Objects.equals(this.billingStartDate, _that.getBillingStartDate())) {
                return false;
            }
            if (!Objects.equals(this.billingEndDate, _that.getBillingEndDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingRecord, _that.getBillingRecord())) {
                return false;
            }
            if (!ListEquals.listEquals(this.billingSummary, _that.getBillingSummary())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.sendingParty != null ? this.sendingParty.hashCode() : 0);
            _result = 31 * _result + (this.receivingParty != null ? this.receivingParty.hashCode() : 0);
            _result = 31 * _result + (this.billingStartDate != null ? this.billingStartDate.hashCode() : 0);
            _result = 31 * _result + (this.billingEndDate != null ? this.billingEndDate.hashCode() : 0);
            _result = 31 * _result + (this.billingRecord != null ? this.billingRecord.hashCode() : 0);
            _result = 31 * _result + (this.billingSummary != null ? this.billingSummary.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "SecurityLendingInvoice {sendingParty=" + this.sendingParty + ", receivingParty=" + this.receivingParty + ", billingStartDate=" + this.billingStartDate + ", billingEndDate=" + this.billingEndDate + ", billingRecord=" + this.billingRecord + ", billingSummary=" + this.billingSummary + ", meta=" + this.meta + '}';
        }
    }

    public static interface SecurityLendingInvoiceBuilder
    extends SecurityLendingInvoice,
    RosettaModelObjectBuilder {
        public Party.PartyBuilder getOrCreateSendingParty();

        @Override
        public Party.PartyBuilder getSendingParty();

        public Party.PartyBuilder getOrCreateReceivingParty();

        @Override
        public Party.PartyBuilder getReceivingParty();

        public BillingRecord.BillingRecordBuilder getOrCreateBillingRecord(int var1);

        public List<? extends BillingRecord.BillingRecordBuilder> getBillingRecord();

        public BillingSummary.BillingSummaryBuilder getOrCreateBillingSummary(int var1);

        public List<? extends BillingSummary.BillingSummaryBuilder> getBillingSummary();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public SecurityLendingInvoiceBuilder setSendingParty(Party var1);

        public SecurityLendingInvoiceBuilder setReceivingParty(Party var1);

        public SecurityLendingInvoiceBuilder setBillingStartDate(Date var1);

        public SecurityLendingInvoiceBuilder setBillingEndDate(Date var1);

        public SecurityLendingInvoiceBuilder addBillingRecord(BillingRecord var1);

        public SecurityLendingInvoiceBuilder addBillingRecord(BillingRecord var1, int var2);

        public SecurityLendingInvoiceBuilder addBillingRecord(List<? extends BillingRecord> var1);

        public SecurityLendingInvoiceBuilder setBillingRecord(List<? extends BillingRecord> var1);

        public SecurityLendingInvoiceBuilder addBillingSummary(BillingSummary var1);

        public SecurityLendingInvoiceBuilder addBillingSummary(BillingSummary var1, int var2);

        public SecurityLendingInvoiceBuilder addBillingSummary(List<? extends BillingSummary> var1);

        public SecurityLendingInvoiceBuilder setBillingSummary(List<? extends BillingSummary> var1);

        public SecurityLendingInvoiceBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("billingStartDate"), Date.class, (Object)this.getBillingStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("billingEndDate"), Date.class, (Object)this.getBillingEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("sendingParty"), processor, Party.PartyBuilder.class, this.getSendingParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("receivingParty"), processor, Party.PartyBuilder.class, this.getReceivingParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("billingRecord"), processor, BillingRecord.BillingRecordBuilder.class, this.getBillingRecord(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("billingSummary"), processor, BillingSummary.BillingSummaryBuilder.class, this.getBillingSummary(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public SecurityLendingInvoiceBuilder prune();
    }
}

