/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralPortfolio;
import cdm.event.common.MarginCallBase;
import cdm.event.common.MarginCallExposure;
import cdm.event.common.MarginCallInstructionType;
import cdm.event.common.RegIMRoleEnum;
import cdm.event.common.RegMarginTypeEnum;
import cdm.event.common.meta.MarginCallIssuanceMeta;
import cdm.event.common.metafields.ReferenceWithMetaCollateralPortfolio;
import cdm.legaldocumentation.common.AgreementName;
import cdm.observable.asset.Money;
import cdm.product.collateral.EligibleCollateralCriteria;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="MarginCallIssuance", builder=MarginCallIssuanceBuilderImpl.class, version="5.0.0")
public interface MarginCallIssuance
extends MarginCallBase {
    public static final MarginCallIssuanceMeta metaData = new MarginCallIssuanceMeta();

    public Money getCallAmountInBaseCurrency();

    public List<? extends EligibleCollateralCriteria> getRecallNonCashCollateralDescription();

    @Override
    public MarginCallIssuance build();

    @Override
    public MarginCallIssuanceBuilder toBuilder();

    public static MarginCallIssuanceBuilder builder() {
        return new MarginCallIssuanceBuilderImpl();
    }

    default public RosettaMetaData<? extends MarginCallIssuance> metaData() {
        return metaData;
    }

    default public Class<? extends MarginCallIssuance> getType() {
        return MarginCallIssuance.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        MarginCallBase.super.process(path, processor);
        this.processRosetta(path.newSubPath("callAmountInBaseCurrency"), processor, Money.class, this.getCallAmountInBaseCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("recallNonCashCollateralDescription"), processor, EligibleCollateralCriteria.class, this.getRecallNonCashCollateralDescription(), new AttributeMeta[0]);
    }

    public static class MarginCallIssuanceBuilderImpl
    extends MarginCallBase.MarginCallBaseBuilderImpl
    implements MarginCallIssuanceBuilder {
        protected Money.MoneyBuilder callAmountInBaseCurrency;
        protected List<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> recallNonCashCollateralDescription = new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>();

        @Override
        @RosettaAttribute(value="callAmountInBaseCurrency")
        public Money.MoneyBuilder getCallAmountInBaseCurrency() {
            return this.callAmountInBaseCurrency;
        }

        @Override
        public Money.MoneyBuilder getOrCreateCallAmountInBaseCurrency() {
            Money.MoneyBuilder result = this.callAmountInBaseCurrency != null ? this.callAmountInBaseCurrency : (this.callAmountInBaseCurrency = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="recallNonCashCollateralDescription")
        public List<? extends EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> getRecallNonCashCollateralDescription() {
            return this.recallNonCashCollateralDescription;
        }

        @Override
        public EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder getOrCreateRecallNonCashCollateralDescription(int _index) {
            if (this.recallNonCashCollateralDescription == null) {
                this.recallNonCashCollateralDescription = new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>();
            }
            return (EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder)this.getIndex(this.recallNonCashCollateralDescription, _index, () -> {
                EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder newRecallNonCashCollateralDescription = EligibleCollateralCriteria.builder();
                return newRecallNonCashCollateralDescription;
            });
        }

        @Override
        @RosettaAttribute(value="callAmountInBaseCurrency")
        public MarginCallIssuanceBuilder setCallAmountInBaseCurrency(Money callAmountInBaseCurrency) {
            this.callAmountInBaseCurrency = callAmountInBaseCurrency == null ? null : callAmountInBaseCurrency.toBuilder();
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(EligibleCollateralCriteria recallNonCashCollateralDescription) {
            if (recallNonCashCollateralDescription != null) {
                this.recallNonCashCollateralDescription.add(recallNonCashCollateralDescription.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(EligibleCollateralCriteria recallNonCashCollateralDescription, int _idx) {
            this.getIndex(this.recallNonCashCollateralDescription, _idx, () -> recallNonCashCollateralDescription.toBuilder());
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(List<? extends EligibleCollateralCriteria> recallNonCashCollateralDescriptions) {
            if (recallNonCashCollateralDescriptions != null) {
                for (EligibleCollateralCriteria eligibleCollateralCriteria : recallNonCashCollateralDescriptions) {
                    this.recallNonCashCollateralDescription.add(eligibleCollateralCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="recallNonCashCollateralDescription")
        public MarginCallIssuanceBuilder setRecallNonCashCollateralDescription(List<? extends EligibleCollateralCriteria> recallNonCashCollateralDescriptions) {
            this.recallNonCashCollateralDescription = recallNonCashCollateralDescriptions == null ? new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>() : (List)recallNonCashCollateralDescriptions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instructionType")
        public MarginCallIssuanceBuilder setInstructionType(MarginCallInstructionType instructionType) {
            this.instructionType = instructionType == null ? null : instructionType.toBuilder();
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addParty(Party party) {
            if (party != null) {
                this.party.add(party.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addParty(Party party, int _idx) {
            this.getIndex(this.party, _idx, () -> party.toBuilder());
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="party")
        public MarginCallIssuanceBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addPartyRole(PartyRole partyRole) {
            if (partyRole != null) {
                this.partyRole.add(partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addPartyRole(PartyRole partyRole, int _idx) {
            this.getIndex(this.partyRole, _idx, () -> partyRole.toBuilder());
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRole")
        public MarginCallIssuanceBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingBroker")
        public MarginCallIssuanceBuilder setClearingBroker(Party clearingBroker) {
            this.clearingBroker = clearingBroker == null ? null : clearingBroker.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callIdentifier")
        public MarginCallIssuanceBuilder setCallIdentifier(Identifier callIdentifier) {
            this.callIdentifier = callIdentifier == null ? null : callIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callAgreementType")
        public MarginCallIssuanceBuilder setCallAgreementType(AgreementName callAgreementType) {
            this.callAgreementType = callAgreementType == null ? null : callAgreementType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementMinimumTransferAmount")
        public MarginCallIssuanceBuilder setAgreementMinimumTransferAmount(Money agreementMinimumTransferAmount) {
            this.agreementMinimumTransferAmount = agreementMinimumTransferAmount == null ? null : agreementMinimumTransferAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementThreshold")
        public MarginCallIssuanceBuilder setAgreementThreshold(Money agreementThreshold) {
            this.agreementThreshold = agreementThreshold == null ? null : agreementThreshold.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementRounding")
        public MarginCallIssuanceBuilder setAgreementRounding(Money agreementRounding) {
            this.agreementRounding = agreementRounding == null ? null : agreementRounding.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regMarginType")
        public MarginCallIssuanceBuilder setRegMarginType(RegMarginTypeEnum regMarginType) {
            this.regMarginType = regMarginType == null ? null : regMarginType;
            return this;
        }

        @Override
        @RosettaAttribute(value="regIMRole")
        public MarginCallIssuanceBuilder setRegIMRole(RegIMRoleEnum regIMRole) {
            this.regIMRole = regIMRole == null ? null : regIMRole;
            return this;
        }

        @Override
        @RosettaAttribute(value="baseCurrencyExposure")
        public MarginCallIssuanceBuilder setBaseCurrencyExposure(MarginCallExposure baseCurrencyExposure) {
            this.baseCurrencyExposure = baseCurrencyExposure == null ? null : baseCurrencyExposure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolio")
        public MarginCallIssuanceBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio collateralPortfolio) {
            this.collateralPortfolio = collateralPortfolio == null ? null : collateralPortfolio.toBuilder();
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder setCollateralPortfolioValue(CollateralPortfolio collateralPortfolio) {
            this.getOrCreateCollateralPortfolio().setValue(collateralPortfolio);
            return this;
        }

        @Override
        @RosettaAttribute(value="independentAmountBalance")
        public MarginCallIssuanceBuilder setIndependentAmountBalance(CollateralBalance independentAmountBalance) {
            this.independentAmountBalance = independentAmountBalance == null ? null : independentAmountBalance.toBuilder();
            return this;
        }

        @Override
        public MarginCallIssuance build() {
            return new MarginCallIssuanceImpl(this);
        }

        @Override
        public MarginCallIssuanceBuilder toBuilder() {
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder prune() {
            super.prune();
            if (this.callAmountInBaseCurrency != null && !this.callAmountInBaseCurrency.prune().hasData()) {
                this.callAmountInBaseCurrency = null;
            }
            this.recallNonCashCollateralDescription = this.recallNonCashCollateralDescription.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCallAmountInBaseCurrency() != null && this.getCallAmountInBaseCurrency().hasData()) {
                return true;
            }
            return this.getRecallNonCashCollateralDescription() != null && this.getRecallNonCashCollateralDescription().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public MarginCallIssuanceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MarginCallIssuanceBuilder o = (MarginCallIssuanceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallAmountInBaseCurrency(), (RosettaModelObjectBuilder)o.getCallAmountInBaseCurrency(), this::setCallAmountInBaseCurrency);
            merger.mergeRosetta(this.getRecallNonCashCollateralDescription(), o.getRecallNonCashCollateralDescription(), this::getOrCreateRecallNonCashCollateralDescription);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallIssuance _that = (MarginCallIssuance)this.getType().cast(o);
            if (!Objects.equals(this.callAmountInBaseCurrency, _that.getCallAmountInBaseCurrency())) {
                return false;
            }
            return ListEquals.listEquals(this.recallNonCashCollateralDescription, _that.getRecallNonCashCollateralDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.callAmountInBaseCurrency != null ? this.callAmountInBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.recallNonCashCollateralDescription != null ? this.recallNonCashCollateralDescription.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallIssuanceBuilder {callAmountInBaseCurrency=" + this.callAmountInBaseCurrency + ", recallNonCashCollateralDescription=" + this.recallNonCashCollateralDescription + '}' + " " + super.toString();
        }
    }

    public static class MarginCallIssuanceImpl
    extends MarginCallBase.MarginCallBaseImpl
    implements MarginCallIssuance {
        private final Money callAmountInBaseCurrency;
        private final List<? extends EligibleCollateralCriteria> recallNonCashCollateralDescription;

        protected MarginCallIssuanceImpl(MarginCallIssuanceBuilder builder) {
            super(builder);
            this.callAmountInBaseCurrency = Optional.ofNullable(builder.getCallAmountInBaseCurrency()).map(f -> f.build()).orElse(null);
            this.recallNonCashCollateralDescription = Optional.ofNullable(builder.getRecallNonCashCollateralDescription()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="callAmountInBaseCurrency")
        public Money getCallAmountInBaseCurrency() {
            return this.callAmountInBaseCurrency;
        }

        @Override
        @RosettaAttribute(value="recallNonCashCollateralDescription")
        public List<? extends EligibleCollateralCriteria> getRecallNonCashCollateralDescription() {
            return this.recallNonCashCollateralDescription;
        }

        @Override
        public MarginCallIssuance build() {
            return this;
        }

        @Override
        public MarginCallIssuanceBuilder toBuilder() {
            MarginCallIssuanceBuilder builder = MarginCallIssuance.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MarginCallIssuanceBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCallAmountInBaseCurrency()).ifPresent(builder::setCallAmountInBaseCurrency);
            Optional.ofNullable(this.getRecallNonCashCollateralDescription()).ifPresent(builder::setRecallNonCashCollateralDescription);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MarginCallIssuance _that = (MarginCallIssuance)this.getType().cast(o);
            if (!Objects.equals(this.callAmountInBaseCurrency, _that.getCallAmountInBaseCurrency())) {
                return false;
            }
            return ListEquals.listEquals(this.recallNonCashCollateralDescription, _that.getRecallNonCashCollateralDescription());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.callAmountInBaseCurrency != null ? this.callAmountInBaseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.recallNonCashCollateralDescription != null ? this.recallNonCashCollateralDescription.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MarginCallIssuance {callAmountInBaseCurrency=" + this.callAmountInBaseCurrency + ", recallNonCashCollateralDescription=" + this.recallNonCashCollateralDescription + '}' + " " + super.toString();
        }
    }

    public static interface MarginCallIssuanceBuilder
    extends MarginCallIssuance,
    MarginCallBase.MarginCallBaseBuilder,
    RosettaModelObjectBuilder {
        public Money.MoneyBuilder getOrCreateCallAmountInBaseCurrency();

        @Override
        public Money.MoneyBuilder getCallAmountInBaseCurrency();

        public EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder getOrCreateRecallNonCashCollateralDescription(int var1);

        public List<? extends EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> getRecallNonCashCollateralDescription();

        public MarginCallIssuanceBuilder setCallAmountInBaseCurrency(Money var1);

        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(EligibleCollateralCriteria var1);

        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(EligibleCollateralCriteria var1, int var2);

        public MarginCallIssuanceBuilder addRecallNonCashCollateralDescription(List<? extends EligibleCollateralCriteria> var1);

        public MarginCallIssuanceBuilder setRecallNonCashCollateralDescription(List<? extends EligibleCollateralCriteria> var1);

        @Override
        public MarginCallIssuanceBuilder setInstructionType(MarginCallInstructionType var1);

        @Override
        public MarginCallIssuanceBuilder addParty(Party var1);

        @Override
        public MarginCallIssuanceBuilder addParty(Party var1, int var2);

        @Override
        public MarginCallIssuanceBuilder addParty(List<? extends Party> var1);

        @Override
        public MarginCallIssuanceBuilder setParty(List<? extends Party> var1);

        @Override
        public MarginCallIssuanceBuilder addPartyRole(PartyRole var1);

        @Override
        public MarginCallIssuanceBuilder addPartyRole(PartyRole var1, int var2);

        @Override
        public MarginCallIssuanceBuilder addPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallIssuanceBuilder setPartyRole(List<? extends PartyRole> var1);

        @Override
        public MarginCallIssuanceBuilder setClearingBroker(Party var1);

        @Override
        public MarginCallIssuanceBuilder setCallIdentifier(Identifier var1);

        @Override
        public MarginCallIssuanceBuilder setCallAgreementType(AgreementName var1);

        @Override
        public MarginCallIssuanceBuilder setAgreementMinimumTransferAmount(Money var1);

        @Override
        public MarginCallIssuanceBuilder setAgreementThreshold(Money var1);

        @Override
        public MarginCallIssuanceBuilder setAgreementRounding(Money var1);

        @Override
        public MarginCallIssuanceBuilder setRegMarginType(RegMarginTypeEnum var1);

        @Override
        public MarginCallIssuanceBuilder setRegIMRole(RegIMRoleEnum var1);

        @Override
        public MarginCallIssuanceBuilder setBaseCurrencyExposure(MarginCallExposure var1);

        @Override
        public MarginCallIssuanceBuilder setCollateralPortfolio(ReferenceWithMetaCollateralPortfolio var1);

        @Override
        public MarginCallIssuanceBuilder setCollateralPortfolioValue(CollateralPortfolio var1);

        @Override
        public MarginCallIssuanceBuilder setIndependentAmountBalance(CollateralBalance var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            MarginCallBase.MarginCallBaseBuilder.super.process(path, processor);
            this.processRosetta(path.newSubPath("callAmountInBaseCurrency"), processor, Money.MoneyBuilder.class, this.getCallAmountInBaseCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("recallNonCashCollateralDescription"), processor, EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder.class, this.getRecallNonCashCollateralDescription(), new AttributeMeta[0]);
        }

        @Override
        public MarginCallIssuanceBuilder prune();
    }
}

