/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.meta.ExerciseEventMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ExerciseEvent", builder=ExerciseEventBuilderImpl.class, version="5.0.0")
public interface ExerciseEvent
extends RosettaModelObject,
GlobalKey {
    public static final ExerciseEventMeta metaData = new ExerciseEventMeta();

    public Date getAdjustedExerciseDate();

    public Date getAdjustedRelevantSwapEffectiveDate();

    public Date getAdjustedCashSettlementValuationDate();

    public Date getAdjustedCashSettlementPaymentDate();

    public Date getAdjustedExerciseFeePaymentDate();

    public MetaFields getMeta();

    public ExerciseEvent build();

    public ExerciseEventBuilder toBuilder();

    public static ExerciseEventBuilder builder() {
        return new ExerciseEventBuilderImpl();
    }

    default public RosettaMetaData<? extends ExerciseEvent> metaData() {
        return metaData;
    }

    default public Class<? extends ExerciseEvent> getType() {
        return ExerciseEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("adjustedExerciseDate"), Date.class, (Object)this.getAdjustedExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedRelevantSwapEffectiveDate"), Date.class, (Object)this.getAdjustedRelevantSwapEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedCashSettlementValuationDate"), Date.class, (Object)this.getAdjustedCashSettlementValuationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedCashSettlementPaymentDate"), Date.class, (Object)this.getAdjustedCashSettlementPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedExerciseFeePaymentDate"), Date.class, (Object)this.getAdjustedExerciseFeePaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, this.getMeta(), new AttributeMeta[0]);
    }

    public static class ExerciseEventBuilderImpl
    implements ExerciseEventBuilder,
    GlobalKey.GlobalKeyBuilder {
        protected Date adjustedExerciseDate;
        protected Date adjustedRelevantSwapEffectiveDate;
        protected Date adjustedCashSettlementValuationDate;
        protected Date adjustedCashSettlementPaymentDate;
        protected Date adjustedExerciseFeePaymentDate;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="adjustedExerciseDate")
        public Date getAdjustedExerciseDate() {
            return this.adjustedExerciseDate;
        }

        @Override
        @RosettaAttribute(value="adjustedRelevantSwapEffectiveDate")
        public Date getAdjustedRelevantSwapEffectiveDate() {
            return this.adjustedRelevantSwapEffectiveDate;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementValuationDate")
        public Date getAdjustedCashSettlementValuationDate() {
            return this.adjustedCashSettlementValuationDate;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementPaymentDate")
        public Date getAdjustedCashSettlementPaymentDate() {
            return this.adjustedCashSettlementPaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseFeePaymentDate")
        public Date getAdjustedExerciseFeePaymentDate() {
            return this.adjustedExerciseFeePaymentDate;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseDate")
        public ExerciseEventBuilder setAdjustedExerciseDate(Date adjustedExerciseDate) {
            this.adjustedExerciseDate = adjustedExerciseDate == null ? null : adjustedExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedRelevantSwapEffectiveDate")
        public ExerciseEventBuilder setAdjustedRelevantSwapEffectiveDate(Date adjustedRelevantSwapEffectiveDate) {
            this.adjustedRelevantSwapEffectiveDate = adjustedRelevantSwapEffectiveDate == null ? null : adjustedRelevantSwapEffectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementValuationDate")
        public ExerciseEventBuilder setAdjustedCashSettlementValuationDate(Date adjustedCashSettlementValuationDate) {
            this.adjustedCashSettlementValuationDate = adjustedCashSettlementValuationDate == null ? null : adjustedCashSettlementValuationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementPaymentDate")
        public ExerciseEventBuilder setAdjustedCashSettlementPaymentDate(Date adjustedCashSettlementPaymentDate) {
            this.adjustedCashSettlementPaymentDate = adjustedCashSettlementPaymentDate == null ? null : adjustedCashSettlementPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseFeePaymentDate")
        public ExerciseEventBuilder setAdjustedExerciseFeePaymentDate(Date adjustedExerciseFeePaymentDate) {
            this.adjustedExerciseFeePaymentDate = adjustedExerciseFeePaymentDate == null ? null : adjustedExerciseFeePaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        public ExerciseEventBuilder setMeta(MetaFields meta) {
            this.meta = meta == null ? null : meta.toBuilder();
            return this;
        }

        @Override
        public ExerciseEvent build() {
            return new ExerciseEventImpl(this);
        }

        @Override
        public ExerciseEventBuilder toBuilder() {
            return this;
        }

        @Override
        public ExerciseEventBuilder prune() {
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAdjustedExerciseDate() != null) {
                return true;
            }
            if (this.getAdjustedRelevantSwapEffectiveDate() != null) {
                return true;
            }
            if (this.getAdjustedCashSettlementValuationDate() != null) {
                return true;
            }
            if (this.getAdjustedCashSettlementPaymentDate() != null) {
                return true;
            }
            return this.getAdjustedExerciseFeePaymentDate() != null;
        }

        public ExerciseEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExerciseEventBuilder o = (ExerciseEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic((Object)this.getAdjustedExerciseDate(), (Object)o.getAdjustedExerciseDate(), this::setAdjustedExerciseDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedRelevantSwapEffectiveDate(), (Object)o.getAdjustedRelevantSwapEffectiveDate(), this::setAdjustedRelevantSwapEffectiveDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedCashSettlementValuationDate(), (Object)o.getAdjustedCashSettlementValuationDate(), this::setAdjustedCashSettlementValuationDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedCashSettlementPaymentDate(), (Object)o.getAdjustedCashSettlementPaymentDate(), this::setAdjustedCashSettlementPaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedExerciseFeePaymentDate(), (Object)o.getAdjustedExerciseFeePaymentDate(), this::setAdjustedExerciseFeePaymentDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExerciseEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedExerciseDate, _that.getAdjustedExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedRelevantSwapEffectiveDate, _that.getAdjustedRelevantSwapEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedCashSettlementValuationDate, _that.getAdjustedCashSettlementValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedCashSettlementPaymentDate, _that.getAdjustedCashSettlementPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedExerciseFeePaymentDate, _that.getAdjustedExerciseFeePaymentDate())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedExerciseDate != null ? this.adjustedExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedRelevantSwapEffectiveDate != null ? this.adjustedRelevantSwapEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedCashSettlementValuationDate != null ? this.adjustedCashSettlementValuationDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedCashSettlementPaymentDate != null ? this.adjustedCashSettlementPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedExerciseFeePaymentDate != null ? this.adjustedExerciseFeePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExerciseEventBuilder {adjustedExerciseDate=" + this.adjustedExerciseDate + ", adjustedRelevantSwapEffectiveDate=" + this.adjustedRelevantSwapEffectiveDate + ", adjustedCashSettlementValuationDate=" + this.adjustedCashSettlementValuationDate + ", adjustedCashSettlementPaymentDate=" + this.adjustedCashSettlementPaymentDate + ", adjustedExerciseFeePaymentDate=" + this.adjustedExerciseFeePaymentDate + ", meta=" + this.meta + '}';
        }
    }

    public static class ExerciseEventImpl
    implements ExerciseEvent {
        private final Date adjustedExerciseDate;
        private final Date adjustedRelevantSwapEffectiveDate;
        private final Date adjustedCashSettlementValuationDate;
        private final Date adjustedCashSettlementPaymentDate;
        private final Date adjustedExerciseFeePaymentDate;
        private final MetaFields meta;

        protected ExerciseEventImpl(ExerciseEventBuilder builder) {
            this.adjustedExerciseDate = builder.getAdjustedExerciseDate();
            this.adjustedRelevantSwapEffectiveDate = builder.getAdjustedRelevantSwapEffectiveDate();
            this.adjustedCashSettlementValuationDate = builder.getAdjustedCashSettlementValuationDate();
            this.adjustedCashSettlementPaymentDate = builder.getAdjustedCashSettlementPaymentDate();
            this.adjustedExerciseFeePaymentDate = builder.getAdjustedExerciseFeePaymentDate();
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseDate")
        public Date getAdjustedExerciseDate() {
            return this.adjustedExerciseDate;
        }

        @Override
        @RosettaAttribute(value="adjustedRelevantSwapEffectiveDate")
        public Date getAdjustedRelevantSwapEffectiveDate() {
            return this.adjustedRelevantSwapEffectiveDate;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementValuationDate")
        public Date getAdjustedCashSettlementValuationDate() {
            return this.adjustedCashSettlementValuationDate;
        }

        @Override
        @RosettaAttribute(value="adjustedCashSettlementPaymentDate")
        public Date getAdjustedCashSettlementPaymentDate() {
            return this.adjustedCashSettlementPaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedExerciseFeePaymentDate")
        public Date getAdjustedExerciseFeePaymentDate() {
            return this.adjustedExerciseFeePaymentDate;
        }

        @Override
        @RosettaAttribute(value="meta")
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public ExerciseEvent build() {
            return this;
        }

        @Override
        public ExerciseEventBuilder toBuilder() {
            ExerciseEventBuilder builder = ExerciseEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExerciseEventBuilder builder) {
            Optional.ofNullable(this.getAdjustedExerciseDate()).ifPresent(builder::setAdjustedExerciseDate);
            Optional.ofNullable(this.getAdjustedRelevantSwapEffectiveDate()).ifPresent(builder::setAdjustedRelevantSwapEffectiveDate);
            Optional.ofNullable(this.getAdjustedCashSettlementValuationDate()).ifPresent(builder::setAdjustedCashSettlementValuationDate);
            Optional.ofNullable(this.getAdjustedCashSettlementPaymentDate()).ifPresent(builder::setAdjustedCashSettlementPaymentDate);
            Optional.ofNullable(this.getAdjustedExerciseFeePaymentDate()).ifPresent(builder::setAdjustedExerciseFeePaymentDate);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExerciseEvent _that = this.getType().cast(o);
            if (!Objects.equals(this.adjustedExerciseDate, _that.getAdjustedExerciseDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedRelevantSwapEffectiveDate, _that.getAdjustedRelevantSwapEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedCashSettlementValuationDate, _that.getAdjustedCashSettlementValuationDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedCashSettlementPaymentDate, _that.getAdjustedCashSettlementPaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedExerciseFeePaymentDate, _that.getAdjustedExerciseFeePaymentDate())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.adjustedExerciseDate != null ? this.adjustedExerciseDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedRelevantSwapEffectiveDate != null ? this.adjustedRelevantSwapEffectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedCashSettlementValuationDate != null ? this.adjustedCashSettlementValuationDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedCashSettlementPaymentDate != null ? this.adjustedCashSettlementPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedExerciseFeePaymentDate != null ? this.adjustedExerciseFeePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExerciseEvent {adjustedExerciseDate=" + this.adjustedExerciseDate + ", adjustedRelevantSwapEffectiveDate=" + this.adjustedRelevantSwapEffectiveDate + ", adjustedCashSettlementValuationDate=" + this.adjustedCashSettlementValuationDate + ", adjustedCashSettlementPaymentDate=" + this.adjustedCashSettlementPaymentDate + ", adjustedExerciseFeePaymentDate=" + this.adjustedExerciseFeePaymentDate + ", meta=" + this.meta + '}';
        }
    }

    public static interface ExerciseEventBuilder
    extends ExerciseEvent,
    RosettaModelObjectBuilder {
        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        @Override
        public MetaFields.MetaFieldsBuilder getMeta();

        public ExerciseEventBuilder setAdjustedExerciseDate(Date var1);

        public ExerciseEventBuilder setAdjustedRelevantSwapEffectiveDate(Date var1);

        public ExerciseEventBuilder setAdjustedCashSettlementValuationDate(Date var1);

        public ExerciseEventBuilder setAdjustedCashSettlementPaymentDate(Date var1);

        public ExerciseEventBuilder setAdjustedExerciseFeePaymentDate(Date var1);

        public ExerciseEventBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("adjustedExerciseDate"), Date.class, (Object)this.getAdjustedExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedRelevantSwapEffectiveDate"), Date.class, (Object)this.getAdjustedRelevantSwapEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedCashSettlementValuationDate"), Date.class, (Object)this.getAdjustedCashSettlementValuationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedCashSettlementPaymentDate"), Date.class, (Object)this.getAdjustedCashSettlementPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedExerciseFeePaymentDate"), Date.class, (Object)this.getAdjustedExerciseFeePaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, this.getMeta(), new AttributeMeta[0]);
        }

        public ExerciseEventBuilder prune();
    }
}

