/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="EventIntentEnum")
public enum EventIntentEnum {
    ALLOCATION("Allocation"),
    CASH_FLOW("CashFlow"),
    CLEARING("Clearing"),
    COMPRESSION("Compression"),
    CONTRACT_FORMATION("ContractFormation"),
    CONTRACT_TERMS_AMENDMENT("ContractTermsAmendment"),
    CORPORATE_ACTION_ADJUSTMENT("CorporateActionAdjustment"),
    CREDIT_EVENT("CreditEvent"),
    DECREASE("Decrease"),
    EARLY_TERMINATION_PROVISION("EarlyTerminationProvision"),
    INCREASE("Increase"),
    INDEX_TRANSITION("IndexTransition"),
    NOTIONAL_RESET("NotionalReset"),
    NOTIONAL_STEP("NotionalStep"),
    NOVATION("Novation"),
    OBSERVATION_RECORD("ObservationRecord"),
    OPTION_EXERCISE("OptionExercise"),
    OPTIONAL_EXTENSION("OptionalExtension"),
    OPTIONAL_CANCELLATION("OptionalCancellation"),
    PRINCIPAL_EXCHANGE("PrincipalExchange"),
    REALLOCATION("Reallocation"),
    REPURCHASE("Repurchase");

    private static Map<String, EventIntentEnum> values;
    private final String rosettaName;
    private final String displayName;

    private EventIntentEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private EventIntentEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static EventIntentEnum fromDisplayName(String name) {
        EventIntentEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, EventIntentEnum> map = new ConcurrentHashMap<String, EventIntentEnum>();
        for (EventIntentEnum instance : EventIntentEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

