/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.event.common.CorporateActionTypeEnum;
import cdm.event.common.CounterpartyPositionState;
import cdm.event.common.PositionEventIntentEnum;
import cdm.event.common.meta.CounterpartyPositionBusinessEventMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CounterpartyPositionBusinessEvent", builder=CounterpartyPositionBusinessEventBuilderImpl.class, version="5.0.0")
public interface CounterpartyPositionBusinessEvent
extends RosettaModelObject {
    public static final CounterpartyPositionBusinessEventMeta metaData = new CounterpartyPositionBusinessEventMeta();

    public PositionEventIntentEnum getIntent();

    public CorporateActionTypeEnum getCorporateActionIntent();

    public Date getEventDate();

    public Date getEffectiveDate();

    public IdentifiedList getPackageInformation();

    public CounterpartyPositionState getAfter();

    public CounterpartyPositionBusinessEvent build();

    public CounterpartyPositionBusinessEventBuilder toBuilder();

    public static CounterpartyPositionBusinessEventBuilder builder() {
        return new CounterpartyPositionBusinessEventBuilderImpl();
    }

    default public RosettaMetaData<? extends CounterpartyPositionBusinessEvent> metaData() {
        return metaData;
    }

    default public Class<? extends CounterpartyPositionBusinessEvent> getType() {
        return CounterpartyPositionBusinessEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("intent"), PositionEventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.class, this.getPackageInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("after"), processor, CounterpartyPositionState.class, this.getAfter(), new AttributeMeta[0]);
    }

    public static class CounterpartyPositionBusinessEventBuilderImpl
    implements CounterpartyPositionBusinessEventBuilder {
        protected PositionEventIntentEnum intent;
        protected CorporateActionTypeEnum corporateActionIntent;
        protected Date eventDate;
        protected Date effectiveDate;
        protected IdentifiedList.IdentifiedListBuilder packageInformation;
        protected CounterpartyPositionState.CounterpartyPositionStateBuilder after;

        @Override
        @RosettaAttribute(value="intent")
        public PositionEventIntentEnum getIntent() {
            return this.intent;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        public CorporateActionTypeEnum getCorporateActionIntent() {
            return this.corporateActionIntent;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        public IdentifiedList.IdentifiedListBuilder getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageInformation() {
            IdentifiedList.IdentifiedListBuilder result = this.packageInformation != null ? this.packageInformation : (this.packageInformation = IdentifiedList.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="after")
        public CounterpartyPositionState.CounterpartyPositionStateBuilder getAfter() {
            return this.after;
        }

        @Override
        public CounterpartyPositionState.CounterpartyPositionStateBuilder getOrCreateAfter() {
            CounterpartyPositionState.CounterpartyPositionStateBuilder result = this.after != null ? this.after : (this.after = CounterpartyPositionState.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="intent")
        public CounterpartyPositionBusinessEventBuilder setIntent(PositionEventIntentEnum intent) {
            this.intent = intent == null ? null : intent;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        public CounterpartyPositionBusinessEventBuilder setCorporateActionIntent(CorporateActionTypeEnum corporateActionIntent) {
            this.corporateActionIntent = corporateActionIntent == null ? null : corporateActionIntent;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        public CounterpartyPositionBusinessEventBuilder setEventDate(Date eventDate) {
            this.eventDate = eventDate == null ? null : eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        public CounterpartyPositionBusinessEventBuilder setEffectiveDate(Date effectiveDate) {
            this.effectiveDate = effectiveDate == null ? null : effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        public CounterpartyPositionBusinessEventBuilder setPackageInformation(IdentifiedList packageInformation) {
            this.packageInformation = packageInformation == null ? null : packageInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="after")
        public CounterpartyPositionBusinessEventBuilder setAfter(CounterpartyPositionState after) {
            this.after = after == null ? null : after.toBuilder();
            return this;
        }

        @Override
        public CounterpartyPositionBusinessEvent build() {
            return new CounterpartyPositionBusinessEventImpl(this);
        }

        @Override
        public CounterpartyPositionBusinessEventBuilder toBuilder() {
            return this;
        }

        @Override
        public CounterpartyPositionBusinessEventBuilder prune() {
            if (this.packageInformation != null && !this.packageInformation.prune().hasData()) {
                this.packageInformation = null;
            }
            if (this.after != null && !this.after.prune().hasData()) {
                this.after = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIntent() != null) {
                return true;
            }
            if (this.getCorporateActionIntent() != null) {
                return true;
            }
            if (this.getEventDate() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getPackageInformation() != null && this.getPackageInformation().hasData()) {
                return true;
            }
            return this.getAfter() != null && this.getAfter().hasData();
        }

        public CounterpartyPositionBusinessEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CounterpartyPositionBusinessEventBuilder o = (CounterpartyPositionBusinessEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageInformation(), (RosettaModelObjectBuilder)o.getPackageInformation(), this::setPackageInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAfter(), (RosettaModelObjectBuilder)o.getAfter(), this::setAfter);
            merger.mergeBasic((Object)this.getIntent(), (Object)o.getIntent(), this::setIntent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCorporateActionIntent(), (Object)o.getCorporateActionIntent(), this::setCorporateActionIntent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CounterpartyPositionBusinessEvent _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.intent, (Object)_that.getIntent())) {
                return false;
            }
            if (!Objects.equals((Object)this.corporateActionIntent, (Object)_that.getCorporateActionIntent())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.packageInformation, _that.getPackageInformation())) {
                return false;
            }
            return Objects.equals(this.after, _that.getAfter());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.intent != null ? ((Object)((Object)this.intent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.corporateActionIntent != null ? ((Object)((Object)this.corporateActionIntent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            _result = 31 * _result + (this.after != null ? this.after.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CounterpartyPositionBusinessEventBuilder {intent=" + (Object)((Object)this.intent) + ", corporateActionIntent=" + (Object)((Object)this.corporateActionIntent) + ", eventDate=" + this.eventDate + ", effectiveDate=" + this.effectiveDate + ", packageInformation=" + this.packageInformation + ", after=" + this.after + '}';
        }
    }

    public static class CounterpartyPositionBusinessEventImpl
    implements CounterpartyPositionBusinessEvent {
        private final PositionEventIntentEnum intent;
        private final CorporateActionTypeEnum corporateActionIntent;
        private final Date eventDate;
        private final Date effectiveDate;
        private final IdentifiedList packageInformation;
        private final CounterpartyPositionState after;

        protected CounterpartyPositionBusinessEventImpl(CounterpartyPositionBusinessEventBuilder builder) {
            this.intent = builder.getIntent();
            this.corporateActionIntent = builder.getCorporateActionIntent();
            this.eventDate = builder.getEventDate();
            this.effectiveDate = builder.getEffectiveDate();
            this.packageInformation = Optional.ofNullable(builder.getPackageInformation()).map(f -> f.build()).orElse(null);
            this.after = Optional.ofNullable(builder.getAfter()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="intent")
        public PositionEventIntentEnum getIntent() {
            return this.intent;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        public CorporateActionTypeEnum getCorporateActionIntent() {
            return this.corporateActionIntent;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        public IdentifiedList getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        @RosettaAttribute(value="after")
        public CounterpartyPositionState getAfter() {
            return this.after;
        }

        @Override
        public CounterpartyPositionBusinessEvent build() {
            return this;
        }

        @Override
        public CounterpartyPositionBusinessEventBuilder toBuilder() {
            CounterpartyPositionBusinessEventBuilder builder = CounterpartyPositionBusinessEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CounterpartyPositionBusinessEventBuilder builder) {
            Optional.ofNullable(this.getIntent()).ifPresent(builder::setIntent);
            Optional.ofNullable(this.getCorporateActionIntent()).ifPresent(builder::setCorporateActionIntent);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDate);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getPackageInformation()).ifPresent(builder::setPackageInformation);
            Optional.ofNullable(this.getAfter()).ifPresent(builder::setAfter);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CounterpartyPositionBusinessEvent _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.intent, (Object)_that.getIntent())) {
                return false;
            }
            if (!Objects.equals((Object)this.corporateActionIntent, (Object)_that.getCorporateActionIntent())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.packageInformation, _that.getPackageInformation())) {
                return false;
            }
            return Objects.equals(this.after, _that.getAfter());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.intent != null ? ((Object)((Object)this.intent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.corporateActionIntent != null ? ((Object)((Object)this.corporateActionIntent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            _result = 31 * _result + (this.after != null ? this.after.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CounterpartyPositionBusinessEvent {intent=" + (Object)((Object)this.intent) + ", corporateActionIntent=" + (Object)((Object)this.corporateActionIntent) + ", eventDate=" + this.eventDate + ", effectiveDate=" + this.effectiveDate + ", packageInformation=" + this.packageInformation + ", after=" + this.after + '}';
        }
    }

    public static interface CounterpartyPositionBusinessEventBuilder
    extends CounterpartyPositionBusinessEvent,
    RosettaModelObjectBuilder {
        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageInformation();

        @Override
        public IdentifiedList.IdentifiedListBuilder getPackageInformation();

        public CounterpartyPositionState.CounterpartyPositionStateBuilder getOrCreateAfter();

        @Override
        public CounterpartyPositionState.CounterpartyPositionStateBuilder getAfter();

        public CounterpartyPositionBusinessEventBuilder setIntent(PositionEventIntentEnum var1);

        public CounterpartyPositionBusinessEventBuilder setCorporateActionIntent(CorporateActionTypeEnum var1);

        public CounterpartyPositionBusinessEventBuilder setEventDate(Date var1);

        public CounterpartyPositionBusinessEventBuilder setEffectiveDate(Date var1);

        public CounterpartyPositionBusinessEventBuilder setPackageInformation(IdentifiedList var1);

        public CounterpartyPositionBusinessEventBuilder setAfter(CounterpartyPositionState var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("intent"), PositionEventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.IdentifiedListBuilder.class, this.getPackageInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("after"), processor, CounterpartyPositionState.CounterpartyPositionStateBuilder.class, this.getAfter(), new AttributeMeta[0]);
        }

        public CounterpartyPositionBusinessEventBuilder prune();
    }
}

