/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="EntityTypeEnum")
public enum EntityTypeEnum {
    ASIAN("Asian"),
    AUSTRALIAN_AND_NEW_ZEALAND("AustralianAndNewZealand"),
    EUROPEAN_EMERGING_MARKETS("EuropeanEmergingMarkets"),
    JAPANESE("Japanese"),
    NORTH_AMERICAN_HIGH_YIELD("NorthAmericanHighYield"),
    NORTH_AMERICAN_INSURANCE("NorthAmericanInsurance"),
    NORTH_AMERICAN_INVESTMENT_GRADE("NorthAmericanInvestmentGrade"),
    SINGAPOREAN("Singaporean"),
    WESTERN_EUROPEAN("WesternEuropean"),
    WESTERN_EUROPEAN_INSURANCE("WesternEuropeanInsurance");

    private static Map<String, EntityTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private EntityTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private EntityTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static EntityTypeEnum fromDisplayName(String name) {
        EntityTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, EntityTypeEnum> map = new ConcurrentHashMap<String, EntityTypeEnum>();
        for (EntityTypeEnum instance : EntityTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

