/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="TaxonomySourceEnum")
public enum TaxonomySourceEnum {
    CFI("CFI"),
    ISDA("ISDA"),
    ICAD("ICAD"),
    EMIR("EMIR"),
    EU_EMIR_ELIGIBLE_COLLATERAL_ASSET_CLASS("EU_EMIR_EligibleCollateralAssetClass"),
    UK_EMIR_ELIGIBLE_COLLATERAL_ASSET_CLASS("UK_EMIR_EligibleCollateralAssetClass"),
    US_CFTC_PR_ELIGIBLE_COLLATERAL_ASSET_CLASS("US_CFTC_PR_EligibleCollateralAssetClass"),
    OTHER("Other");

    private static Map<String, TaxonomySourceEnum> values;
    private final String rosettaName;
    private final String displayName;

    private TaxonomySourceEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private TaxonomySourceEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static TaxonomySourceEnum fromDisplayName(String name) {
        TaxonomySourceEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, TaxonomySourceEnum> map = new ConcurrentHashMap<String, TaxonomySourceEnum>();
        for (TaxonomySourceEnum instance : TaxonomySourceEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

