/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="SecurityTypeEnum")
public enum SecurityTypeEnum {
    DEBT("Debt"),
    EQUITY("Equity"),
    FUND("Fund"),
    WARRANT("Warrant"),
    CERTIFICATE("Certificate"),
    LETTER_OF_CREDIT("LetterOfCredit"),
    LISTED_DERIVATIVE("ListedDerivative");

    private static Map<String, SecurityTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private SecurityTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private SecurityTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static SecurityTypeEnum fromDisplayName(String name) {
        SecurityTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, SecurityTypeEnum> map = new ConcurrentHashMap<String, SecurityTypeEnum>();
        for (SecurityTypeEnum instance : SecurityTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

