/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="ProductIdTypeEnum")
public enum ProductIdTypeEnum {
    BBGID("BBGID"),
    BBGTICKER("BBGTICKER"),
    CUSIP("CUSIP"),
    FIGI("FIGI"),
    ISDACRP("ISDACRP"),
    ISIN("ISIN"),
    NAME("Name"),
    RIC("RIC"),
    OTHER("Other"),
    SICOVAM("Sicovam"),
    SEDOL("SEDOL"),
    UPI("UPI"),
    WERTPAPIER("Wertpapier");

    private static Map<String, ProductIdTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private ProductIdTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private ProductIdTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static ProductIdTypeEnum fromDisplayName(String name) {
        ProductIdTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, ProductIdTypeEnum> map = new ConcurrentHashMap<String, ProductIdTypeEnum>();
        for (ProductIdTypeEnum instance : ProductIdTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

