/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="FundProductTypeEnum")
public enum FundProductTypeEnum {
    MONEY_MARKET_FUND("MoneyMarketFund"),
    EXCHANGE_TRADED_FUND("ExchangeTradedFund"),
    MUTUAL_FUND("MutualFund"),
    OTHER_FUND("OtherFund");

    private static Map<String, FundProductTypeEnum> values;
    private final String rosettaName;
    private final String displayName;

    private FundProductTypeEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private FundProductTypeEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static FundProductTypeEnum fromDisplayName(String name) {
        FundProductTypeEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, FundProductTypeEnum> map = new ConcurrentHashMap<String, FundProductTypeEnum>();
        for (FundProductTypeEnum instance : FundProductTypeEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

