/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="AssetClassEnum")
public enum AssetClassEnum {
    COMMODITY("Commodity"),
    CREDIT("Credit"),
    EQUITY("Equity"),
    FOREIGN_EXCHANGE("ForeignExchange"),
    INTEREST_RATE("InterestRate"),
    MONEY_MARKET("MoneyMarket");

    private static Map<String, AssetClassEnum> values;
    private final String rosettaName;
    private final String displayName;

    private AssetClassEnum(String rosettaName) {
        this(rosettaName, null);
    }

    private AssetClassEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static AssetClassEnum fromDisplayName(String name) {
        AssetClassEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, AssetClassEnum> map = new ConcurrentHashMap<String, AssetClassEnum>();
        for (AssetClassEnum instance : AssetClassEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

