/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math.functions;

import cdm.base.math.Quantity;
import cdm.base.math.UnitType;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=FilterQuantityDefault.class)
public abstract class FilterQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends Quantity> evaluate(List<? extends Quantity> quantities, UnitType unit) {
        List filteredQuantities;
        List<Quantity.QuantityBuilder> filteredQuantitiesBuilder = this.doEvaluate(quantities, unit);
        if (filteredQuantitiesBuilder == null) {
            filteredQuantities = null;
        } else {
            filteredQuantities = filteredQuantitiesBuilder.stream().map(Quantity::build).collect(Collectors.toList());
            this.objectValidator.validate(Quantity.class, filteredQuantities);
        }
        return filteredQuantities;
    }

    protected abstract List<Quantity.QuantityBuilder> doEvaluate(List<? extends Quantity> var1, UnitType var2);

    public static class FilterQuantityDefault
    extends FilterQuantity {
        @Override
        protected List<Quantity.QuantityBuilder> doEvaluate(List<? extends Quantity> quantities, UnitType unit) {
            ArrayList<Quantity.QuantityBuilder> filteredQuantities = new ArrayList<Quantity.QuantityBuilder>();
            return this.assignOutput(filteredQuantities, quantities, unit);
        }

        protected List<Quantity.QuantityBuilder> assignOutput(List<Quantity.QuantityBuilder> filteredQuantities, List<? extends Quantity> quantities, UnitType unit) {
            List addVar = this.toBuilder(MapperC.of(quantities).filterItemNullSafe(item -> ExpressionOperators.areEqual((Mapper)item.map("getUnit", measureBase -> measureBase.getUnit()), (Mapper)MapperS.of((Object)unit), (CardinalityOperator)CardinalityOperator.All).get()).getMulti());
            filteredQuantities.addAll(addVar);
            return Optional.ofNullable(filteredQuantities).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

