/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="CompareOp")
public enum CompareOp {
    GREATER_THAN("GreaterThan"),
    GREATER_THAN_OR_EQUALS("GreaterThanOrEquals"),
    EQUALS("Equals"),
    LESS_THAN_OR_EQUALS("LessThanOrEquals"),
    LESS_THAN("LessThan");

    private static Map<String, CompareOp> values;
    private final String rosettaName;
    private final String displayName;

    private CompareOp(String rosettaName) {
        this(rosettaName, null);
    }

    private CompareOp(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static CompareOp fromDisplayName(String name) {
        CompareOp value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, CompareOp> map = new ConcurrentHashMap<String, CompareOp>();
        for (CompareOp instance : CompareOp.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

